/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.ArrayConverter;
import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.DoubleConverter;
import org.pipservices4.commons.convert.DurationConverter;
import org.pipservices4.commons.convert.FloatConverter;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.convert.MapConverter;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.convert.TypeCode;

public class TypeConverter {
    private static final Class<?> _booleanType = Boolean.class;
    private static final Class<?> _integerType = Integer.class;
    private static final Class<?> _longType = Long.class;
    private static final Class<?> _stringType = String.class;
    private static final Class<?> _floatType = Float.class;
    private static final Class<?> _doubleType = Double.class;
    private static final Class<?> _dateTimeType = ZonedDateTime.class;
    private static final Class<?> _durationType = Duration.class;
    private static final Class<?> _enumType = Enum.class;
    private static final Class<?> _listType = List.class;
    private static final Class<?> _mapType = Map.class;

    public static TypeCode toTypeCode(Class<?> type) {
        if (type == null) {
            return TypeCode.Unknown;
        }
        if (type.isArray()) {
            return TypeCode.Array;
        }
        if (type.isEnum()) {
            return TypeCode.Enum;
        }
        if (type.isPrimitive()) {
            if (_booleanType.isAssignableFrom(type)) {
                return TypeCode.Boolean;
            }
            if (_doubleType.isAssignableFrom(type)) {
                return TypeCode.Double;
            }
            if (_floatType.isAssignableFrom(type)) {
                return TypeCode.Float;
            }
            if (_longType.isAssignableFrom(type)) {
                return TypeCode.Long;
            }
            if (_integerType.isAssignableFrom(type)) {
                return TypeCode.Integer;
            }
        } else {
            if (_booleanType.isAssignableFrom(type)) {
                return TypeCode.Boolean;
            }
            if (_doubleType.isAssignableFrom(type)) {
                return TypeCode.Double;
            }
            if (_floatType.isAssignableFrom(type)) {
                return TypeCode.Float;
            }
            if (_longType.isAssignableFrom(type)) {
                return TypeCode.Long;
            }
            if (_integerType.isAssignableFrom(type)) {
                return TypeCode.Integer;
            }
            if (_stringType.isAssignableFrom(type)) {
                return TypeCode.String;
            }
            if (_dateTimeType.isAssignableFrom(type)) {
                return TypeCode.DateTime;
            }
            if (_durationType.isAssignableFrom(type)) {
                return TypeCode.Duration;
            }
            if (_mapType.isAssignableFrom(type)) {
                return TypeCode.Map;
            }
            if (_listType.isAssignableFrom(type)) {
                return TypeCode.Array;
            }
            if (_enumType.isAssignableFrom(type)) {
                return TypeCode.Enum;
            }
        }
        return TypeCode.Object;
    }

    public static TypeCode toTypeCode(Object value) {
        if (value == null) {
            return TypeCode.Unknown;
        }
        return TypeConverter.toTypeCode(value instanceof Class ? (Class<?>)value : value.getClass());
    }

    public static <T> T toNullableType(Class<T> type, Object value) {
        TypeCode resultType = TypeConverter.toTypeCode(type);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (resultType == TypeCode.String) {
            return type.cast(StringConverter.toNullableString(value));
        }
        if (resultType == TypeCode.Integer) {
            return type.cast(IntegerConverter.toNullableInteger(value));
        }
        if (resultType == TypeCode.Long) {
            return type.cast(LongConverter.toNullableLong(value));
        }
        if (resultType == TypeCode.Float) {
            return type.cast(FloatConverter.toNullableFloat(value));
        }
        if (resultType == TypeCode.Double) {
            return type.cast(DoubleConverter.toNullableDouble(value));
        }
        if (resultType == TypeCode.Duration) {
            return type.cast(DurationConverter.toNullableDuration(value));
        }
        if (resultType == TypeCode.DateTime) {
            return type.cast(DateTimeConverter.toNullableDateTime(value));
        }
        if (resultType == TypeCode.Array) {
            return type.cast(ArrayConverter.toNullableArray(value));
        }
        if (resultType == TypeCode.Map) {
            return type.cast(MapConverter.toNullableMap(value));
        }
        try {
            return type.cast(value);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public static <T> T toType(Class<T> type, Object value) {
        T result = TypeConverter.toNullableType(type, value);
        if (result != null) {
            return result;
        }
        TypeCode resultType = TypeConverter.toTypeCode(type);
        if (resultType == TypeCode.String) {
            return null;
        }
        if (resultType == TypeCode.Integer) {
            return type.cast(0);
        }
        if (resultType == TypeCode.Long) {
            return type.cast(0L);
        }
        if (resultType == TypeCode.Float) {
            return type.cast(Float.valueOf(0.0f));
        }
        if (resultType == TypeCode.Double) {
            return type.cast(0.0);
        }
        return null;
    }

    public static <T> T toTypeWithDefault(Class<T> type, Object value, T defaultValue) {
        T result = TypeConverter.toNullableType(type, value);
        return result != null ? result : defaultValue;
    }

    public static String toString(TypeCode type) {
        switch (type) {
            case String: {
                return "string";
            }
            case Boolean: {
                return "boolean";
            }
            case Integer: {
                return "integer";
            }
            case Long: {
                return "long";
            }
            case Float: {
                return "float";
            }
            case Double: {
                return "double";
            }
            case DateTime: {
                return "datetime";
            }
            case Duration: {
                return "duration";
            }
            case Object: {
                return "object";
            }
            case Enum: {
                return "enum";
            }
            case Array: {
                return "array";
            }
            case Map: {
                return "map";
            }
        }
        return "unknown";
    }
}

