/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;
import org.pipservices4.commons.convert.LongConverter;

public class DurationConverter {
    public static Duration toNullableDuration(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof Integer) {
            return Duration.ofMillis(((Integer)value).intValue());
        }
        if (value instanceof Short) {
            return Duration.ofMillis(((Short)value).shortValue());
        }
        if (value instanceof Long) {
            return Duration.ofMillis((Long)value);
        }
        if (value instanceof Float) {
            return Duration.ofMillis((long)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Duration.ofMillis((long)((Double)value).doubleValue());
        }
        Long millis = LongConverter.toNullableLong(value);
        return millis != null ? Duration.ofMillis(millis) : null;
    }

    public static Duration toDuration(Object value) {
        return DurationConverter.toDurationWithDefault(value, null);
    }

    public static Duration toDurationWithDefault(Object value, Duration defaultValue) {
        Duration result = DurationConverter.toNullableDuration(value);
        return result != null ? result : defaultValue;
    }
}

