/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.GetPropertyAction;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBContextFactory;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Messages;
import jakarta.xml.bind.ModuleUtil;
import jakarta.xml.bind.ServiceLoaderUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("jakarta.xml.bind");
    static final String DEFAULT_FACTORY_CLASS = "org.glassfish.jaxb.runtime.v2.ContextFactory";
    private static ServiceLoaderUtil.ExceptionHandler<JAXBException> EXCEPTION_HANDLER;

    ContextFinder() {
    }

    private static Throwable handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        Throwable t2 = x.getTargetException();
        if (t2 != null) {
            if (t2 instanceof JAXBException) {
                throw (JAXBException)t2;
            }
            if (t2 instanceof RuntimeException) {
                throw (RuntimeException)t2;
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            return t2;
        }
        return x;
    }

    private static JAXBException handleClassCastException(Class<?> originalType, Class<?> targetType) {
        URL targetTypeURL = ContextFinder.which(targetType);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(originalType).getResource("jakarta/xml/bind/JAXBContext.class"), targetTypeURL));
    }

    static JAXBContext newInstance(String contextPath, Class<?>[] contextPathClasses, String className, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        try {
            Class<?> spFactory = ServiceLoaderUtil.safeLoadClass(className, DEFAULT_FACTORY_CLASS, classLoader);
            return ContextFinder.newInstance(contextPath, contextPathClasses, spFactory, classLoader, properties);
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), x);
        }
        catch (JAXBException | RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", className, x), x);
        }
    }

    static JAXBContext newInstance(String contextPath, Class<?>[] contextPathClasses, Class<?> spFactory, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        try {
            Object obj;
            Method m42;
            ModuleUtil.delegateAddOpensToImplModule(contextPathClasses, spFactory);
            Object context = null;
            try {
                m42 = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m42.invoke(obj, contextPath, classLoader, properties);
            }
            catch (NoSuchMethodException m42) {
                // empty catch block
            }
            if (context == null) {
                m42 = spFactory.getMethod("createContext", String.class, ClassLoader.class);
                obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
                context = m42.invoke(obj, contextPath, classLoader);
            }
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (InvocationTargetException x) {
            Throwable e = ContextFinder.handleInvocationTargetException(x);
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, e), e);
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, x), x);
        }
    }

    private static Object instantiateProviderIfNecessary(final Class<?> implClass) throws JAXBException {
        try {
            if (JAXBContextFactory.class.isAssignableFrom(implClass)) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                });
            }
            return null;
        }
        catch (PrivilegedActionException x) {
            Throwable e = x.getCause() == null ? x : x.getCause();
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", implClass, e), e);
        }
    }

    private static JAXBContext newInstance(Class<?>[] classes, Map<String, ?> properties, String className) throws JAXBException {
        return ContextFinder.newInstance(classes, properties, className, ContextFinder.getContextClassLoader());
    }

    private static JAXBContext newInstance(Class<?>[] classes, Map<String, ?> properties, String className, ClassLoader loader) throws JAXBException {
        Class<?> spi;
        try {
            spi = ServiceLoaderUtil.safeLoadClass(className, DEFAULT_FACTORY_CLASS, loader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{className, ContextFinder.which(spi)});
        }
        return ContextFinder.newInstance(classes, properties, spi);
    }

    static JAXBContext newInstance(Class<?>[] classes, Map<String, ?> properties, Class<?> spFactory) throws JAXBException {
        try {
            ModuleUtil.delegateAddOpensToImplModule(classes, spFactory);
            Method m4 = spFactory.getMethod("createContext", Class[].class, Map.class);
            Object obj = ContextFinder.instantiateProviderIfNecessary(spFactory);
            Object context = m4.invoke(obj, classes, properties);
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new JAXBException(e);
        }
        catch (InvocationTargetException e) {
            Throwable x = ContextFinder.handleInvocationTargetException(e);
            throw new JAXBException(x);
        }
    }

    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        JAXBContextFactory obj;
        if (contextPath == null || contextPath.isEmpty()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        Class<?>[] contextPathClasses = ModuleUtil.getClassesFromContextPath(contextPath, classLoader);
        String factoryName = ContextFinder.classNameFromSystemProperties();
        if (factoryName != null) {
            return ContextFinder.newInstance(contextPath, contextPathClasses, factoryName, classLoader, properties);
        }
        if (properties != null) {
            Object factory = properties.get(factoryId);
            if (factory != null) {
                if (factory instanceof String) {
                    factoryName = (String)factory;
                } else {
                    throw new JAXBException(Messages.format("JAXBContext.IllegalCast", factory.getClass().getName(), "String"));
                }
            }
            if (factoryName != null) {
                return ContextFinder.newInstance(contextPath, contextPathClasses, factoryName, classLoader, properties);
            }
        }
        if ((obj = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER)) != null) {
            ModuleUtil.delegateAddOpensToImplModule(contextPathClasses, obj.getClass());
            return obj.createContext(contextPath, classLoader, properties);
        }
        Iterable<Class> ctxFactories = ServiceLoaderUtil.lookupsUsingOSGiServiceLoader("jakarta.xml.bind.JAXBContextFactory", logger);
        if (ctxFactories != null) {
            for (Class ctxFactory : ctxFactories) {
                try {
                    return ContextFinder.newInstance(contextPath, contextPathClasses, ctxFactory, classLoader, properties);
                }
                catch (Throwable t2) {
                    logger.log(Level.FINE, t2, () -> "Error instantiating provivder " + ctxFactory);
                }
            }
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(contextPath, contextPathClasses, DEFAULT_FACTORY_CLASS, classLoader, properties);
    }

    static JAXBContext find(Class<?>[] classes, Map<String, ?> properties) throws JAXBException {
        JAXBContextFactory factory;
        String factoryClassName = ContextFinder.classNameFromSystemProperties();
        if (factoryClassName != null) {
            return ContextFinder.newInstance(classes, properties, factoryClassName);
        }
        if (properties != null) {
            Object ctxFactory = properties.get("jakarta.xml.bind.JAXBContextFactory");
            if (ctxFactory != null) {
                if (ctxFactory instanceof String) {
                    factoryClassName = (String)ctxFactory;
                } else {
                    throw new JAXBException(Messages.format("JAXBContext.IllegalCast", ctxFactory.getClass().getName(), "String"));
                }
            }
            if (factoryClassName != null) {
                return ContextFinder.newInstance(classes, properties, factoryClassName);
            }
        }
        if ((factory = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER)) != null) {
            ModuleUtil.delegateAddOpensToImplModule(classes, factory.getClass());
            return factory.createContext(classes, properties);
        }
        logger.fine("Trying to create the platform default provider");
        Class ctxFactoryClass = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("jakarta.xml.bind.JAXBContextFactory", logger);
        if (ctxFactoryClass != null) {
            return ContextFinder.newInstance(classes, properties, ctxFactoryClass);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classes, properties, DEFAULT_FACTORY_CLASS);
    }

    private static String classNameFromSystemProperties() throws JAXBException {
        String factoryClassName = ContextFinder.getSystemProperty("jakarta.xml.bind.JAXBContextFactory");
        if (factoryClassName != null) {
            return factoryClassName;
        }
        return null;
    }

    private static String getSystemProperty(String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new GetPropertyAction(property));
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
        return value;
    }

    static URL which(Class<?> clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = ContextFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    static URL which(Class<?> clazz) {
        return ContextFinder.which(clazz, ContextFinder.getClassClassLoader(clazz));
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getClassClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<JAXBException>(){

            @Override
            public JAXBException createException(Throwable throwable, String message) {
                return new JAXBException(message, throwable);
            }
        };
    }
}

