/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.pipservices4.commons.convert.RecursiveMapConverter;

public class JsonConverter {
    private static final ObjectMapper _mapper = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    static {
        _mapper.findAndRegisterModules();
        _mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public static <T> T fromJson(Class<T> type, String value) throws JsonMappingException, JsonParseException, IOException {
        if (value == null) {
            return null;
        }
        return (T)_mapper.readValue(value, type);
    }

    public static <T> T fromJson(TypeReference<T> type, String value) throws JsonMappingException, JsonParseException, IOException {
        if (value == null) {
            return null;
        }
        return (T)_mapper.readValue(value, type);
    }

    public static String toJson(Object value) throws JsonProcessingException {
        if (value == null) {
            return null;
        }
        return _mapper.writeValueAsString(value);
    }

    public static Map<String, Object> toNullableMap(String value) {
        if (value == null) {
            return null;
        }
        try {
            Map map = (Map)_mapper.readValue(value, typeRef);
            return RecursiveMapConverter.toNullableMap(map);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Map<String, Object> toMap(String value) {
        HashMap result = JsonConverter.toNullableMap(value);
        return result != null ? result : new HashMap();
    }

    public static Map<String, Object> toMapWithDefault(String value, Map<String, Object> defaultValue) {
        Map<String, Object> result = JsonConverter.toNullableMap(value);
        return result != null ? result : defaultValue;
    }
}

