/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class MethodReflector {
    private static boolean matchMethod(Method method, String name) {
        int mod = method.getModifiers();
        return method.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isAbstract(mod);
    }

    public static boolean hasMethod(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Method name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        Method[] methodArray = objClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (MethodReflector.matchMethod(method, name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object invokeMethod(Object obj, String name, Object ... args) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Method name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        Method[] methodArray = objClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                if (MethodReflector.matchMethod(method, name)) {
                    return method.invoke(obj, args);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getMethodNames(Object obj) {
        ArrayList<String> methods = new ArrayList<String>();
        Class<?> objClass = obj.getClass();
        Method[] methodArray = objClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (MethodReflector.matchMethod(method, method.getName())) {
                methods.add(method.getName());
            }
            ++n2;
        }
        return methods;
    }
}

