/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.errors;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.pipservices4.commons.data.StringValueMap;

public class ApplicationException
extends Exception {
    private static final long serialVersionUID = -5846403471784245155L;
    private String _message;
    private String _category;
    private int _status = 500;
    private String _code = "UNKNOWN";
    private StringValueMap _details;
    private String _traceId;
    private String _stackTrace;
    private String _cause;

    public ApplicationException() {
        this("Unknown", null, null, null);
    }

    public ApplicationException(String category, String traceId, String code, String message) {
        super(message != null ? message : "Unknown error");
        this._message = message != null ? message : "Unknown error";
        this._traceId = traceId;
        this._code = code != null ? code : "UNKNOWN";
        this._category = category != null ? category : "Unknown";
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this._message;
    }

    public void setMessage(String value) {
        this._message = value;
    }

    @JsonProperty(value="category")
    public String getCategory() {
        return this._category;
    }

    public void setCategory(String value) {
        this._category = value;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this._code;
    }

    public void setCode(String value) {
        this._code = value;
    }

    @JsonProperty(value="status")
    public int getStatus() {
        return this._status;
    }

    public void setStatus(int value) {
        this._status = value;
    }

    @JsonProperty(value="details")
    public StringValueMap getDetails() {
        return this._details;
    }

    public void setDetails(StringValueMap value) {
        this._details = value;
    }

    @JsonProperty(value="trace_id")
    public String getTraceId() {
        return this._traceId;
    }

    public void setTraceId(String value) {
        this._traceId = value;
    }

    @JsonProperty(value="cause")
    public String getCauseString() {
        if (super.getCause() != null) {
            return super.getCause().getMessage();
        }
        return this._cause;
    }

    public void setCauseString(String value) {
        this._cause = value;
    }

    @JsonProperty(value="stack_trace")
    public String getStackTraceString() {
        if (this._stackTrace != null) {
            return this._stackTrace;
        }
        StackTraceElement[] ste = this.getStackTrace();
        StringBuilder builder = new StringBuilder();
        if (ste != null) {
            StackTraceElement[] stackTraceElementArray = ste;
            int n = ste.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (builder.length() > 0) {
                    builder.append(" ");
                }
                builder.append(stackTraceElement.toString());
                ++n2;
            }
        }
        return builder.toString();
    }

    public void setStackTraceString(String value) {
        this._stackTrace = value;
    }

    public ApplicationException withCode(String code) {
        this._code = code != null ? code : "UNKNOWN";
        return this;
    }

    public ApplicationException withStatus(int status) {
        this._status = status;
        return this;
    }

    public ApplicationException withDetails(String key, Object value) {
        this._details = this._details != null ? this._details : new StringValueMap();
        this._details.setAsObject(key, value);
        return this;
    }

    public ApplicationException withCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }

    public ApplicationException withtraceId(String traceId) {
        this._traceId = traceId;
        return this;
    }

    public ApplicationException withStackTrace(String stackTrace) {
        this._stackTrace = stackTrace;
        return this;
    }

    public ApplicationException wrap(Throwable cause) {
        if (cause instanceof ApplicationException) {
            return (ApplicationException)cause;
        }
        this.withCause(cause);
        return this;
    }

    public static ApplicationException wrapException(ApplicationException error, Throwable cause) {
        if (cause instanceof ApplicationException) {
            return (ApplicationException)cause;
        }
        error.withCause(cause);
        return error;
    }
}

