/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ErrorDescription;

public class ErrorDescriptionFactory {
    public static ErrorDescription create(Exception ex) {
        ErrorDescription description = new ErrorDescription();
        if (ex instanceof ApplicationException) {
            description.setCategory(((ApplicationException)ex).getCategory());
            description.setStatus(((ApplicationException)ex).getStatus());
            description.setCode(((ApplicationException)ex).getCode());
            description.setMessage(ex.getMessage());
            description.setDetails(((ApplicationException)ex).getDetails());
            description.setTraceId(((ApplicationException)ex).getTraceId());
            description.setCause(((ApplicationException)ex).getCauseString());
            description.setStackTrace(((ApplicationException)ex).getStackTraceString());
        } else {
            description.setType(ex.getClass().toString());
            description.setCategory("Unknown");
            description.setStatus(500);
            description.setCode("UNKNOWN");
            description.setMessage(ex.getMessage().isEmpty() ? ex.toString() : ex.getMessage());
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            description.setStackTrace(exceptionAsString);
        }
        return description;
    }

    public static ErrorDescription create(Throwable ex, String traceId) {
        ErrorDescription description = new ErrorDescription();
        description.setType(ex.getClass().getCanonicalName());
        description.setCategory("Unknown");
        description.setStatus(500);
        description.setCode("Unknown");
        description.setMessage(ex.getMessage());
        Throwable t = ex.getCause();
        description.setCause(t != null ? t.toString() : null);
        StackTraceElement[] ste = ex.getStackTrace();
        StringBuilder builder = new StringBuilder();
        if (ste != null) {
            StackTraceElement[] stackTraceElementArray = ste;
            int n = ste.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (!builder.isEmpty()) {
                    builder.append(" ");
                }
                builder.append(stackTraceElement.toString());
                ++n2;
            }
        }
        description.setStackTrace(builder.toString());
        description.setTraceId(traceId);
        return description;
    }
}

