/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.StringConverter;

public class RecursiveMapConverter {
    private static final ObjectMapper _mapper = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    private static List<Object> listToMap(Collection<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            result.add(RecursiveMapConverter.valueToMap(item));
        }
        return result;
    }

    private static List<Object> arrayToMap(Object[] array) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            result.add(RecursiveMapConverter.valueToMap(item));
            ++n2;
        }
        return result;
    }

    private static Map<String, Object> mapToMap(Map<Object, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            result.put(StringConverter.toString(entry.getKey()), RecursiveMapConverter.valueToMap(entry.getValue()));
        }
        return result;
    }

    private static Map<String, Object> mapToMap2(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), RecursiveMapConverter.valueToMap(entry.getValue()));
        }
        return result;
    }

    private static Object valueToMap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return value;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isPrimitive()) {
            return value;
        }
        if (value instanceof Map) {
            return RecursiveMapConverter.mapToMap((Map)value);
        }
        if (valueClass.isArray()) {
            return RecursiveMapConverter.arrayToMap((Object[])value);
        }
        if (value instanceof Collection) {
            return RecursiveMapConverter.listToMap((Collection)value);
        }
        try {
            Map map = (Map)_mapper.convertValue(value, typeRef);
            return RecursiveMapConverter.mapToMap2(map);
        }
        catch (Exception ex) {
            return value;
        }
    }

    public static Map<String, Object> toNullableMap(Object value) {
        if (value == null) {
            return null;
        }
        Object result = RecursiveMapConverter.valueToMap(value);
        if (result instanceof Map) {
            return (Map)result;
        }
        return null;
    }

    public static Map<String, Object> toMap(Object value) {
        HashMap result = RecursiveMapConverter.toNullableMap(value);
        return result != null ? result : new HashMap();
    }

    public static Map<String, Object> toMapWithDefault(Object value, Map<String, Object> defaultValue) {
        Map<String, Object> result = RecursiveMapConverter.toNullableMap(value);
        return result != null ? result : defaultValue;
    }
}

