/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyReflector {
    private static boolean matchField(Field field, String name) {
        int mod = field.getModifiers();
        return field.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod);
    }

    private static boolean matchPropertyGetter(Method method, String name) {
        if (method.getName().equals("getClass")) {
            return false;
        }
        int mod = method.getModifiers();
        return method.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isAbstract(mod) && method.getParameterCount() == 0;
    }

    private static boolean matchPropertySetter(Method method, String name) {
        int mod = method.getModifiers();
        return method.getName().equalsIgnoreCase(name) && Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isAbstract(mod) && method.getParameterCount() == 1;
    }

    public static boolean hasProperty(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getFields()) {
            if (!PropertyReflector.matchField(field, (String)name)) continue;
            return true;
        }
        name = "get" + (String)name;
        for (AccessibleObject accessibleObject : objClass.getMethods()) {
            if (!PropertyReflector.matchPropertyGetter((Method)accessibleObject, (String)name)) continue;
            return true;
        }
        return false;
    }

    public static Object getProperty(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getFields()) {
            try {
                if (!PropertyReflector.matchField(field, (String)name)) continue;
                return field.get(obj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        name = "get" + (String)name;
        for (AccessibleObject accessibleObject : objClass.getMethods()) {
            try {
                if (!PropertyReflector.matchPropertyGetter((Method)accessibleObject, (String)name)) continue;
                return ((Method)accessibleObject).invoke(obj, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<String> getPropertyNames(Object obj) {
        ArrayList<String> properties = new ArrayList<String>();
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getFields()) {
            if (!PropertyReflector.matchField(field, field.getName())) continue;
            properties.add(field.getName());
        }
        for (AccessibleObject accessibleObject : objClass.getMethods()) {
            if (!((Method)accessibleObject).getName().startsWith("get") || !PropertyReflector.matchPropertyGetter((Method)accessibleObject, ((Method)accessibleObject).getName())) continue;
            Object name = ((Method)accessibleObject).getName().substring(3);
            name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
            properties.add((String)name);
        }
        return properties;
    }

    public static Map<String, Object> getProperties(Object obj) {
        Object value;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getFields()) {
            try {
                if (!PropertyReflector.matchField(field, field.getName())) continue;
                String name2 = field.getName();
                value = field.get(obj);
                map.put(name2, value);
            }
            catch (Throwable name2) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : objClass.getMethods()) {
            try {
                if (!((Method)accessibleObject).getName().startsWith("get") || !PropertyReflector.matchPropertyGetter((Method)accessibleObject, ((Method)accessibleObject).getName())) continue;
                Object name = ((Method)accessibleObject).getName().substring(3);
                name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
                value = ((Method)accessibleObject).invoke(obj, new Object[0]);
                map.put((String)name, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map;
    }

    public static void setProperty(Object obj, String name, Object value) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        Class<?> objClass = obj.getClass();
        for (Field field : objClass.getFields()) {
            try {
                if (!PropertyReflector.matchField(field, (String)name)) continue;
                field.set(obj, value);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        name = "set" + (String)name;
        for (AccessibleObject accessibleObject : objClass.getMethods()) {
            try {
                if (!PropertyReflector.matchPropertySetter((Method)accessibleObject, (String)name)) continue;
                ((Method)accessibleObject).invoke(obj, value);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setProperties(Object obj, Map<String, Object> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            PropertyReflector.setProperty(obj, entry.getKey(), entry.getValue());
        }
    }
}

