/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.reflect.PropertyReflector;

public class ObjectReader {
    public static Object getValue(Object obj) {
        return obj;
    }

    public static boolean hasProperty(Object obj, String name) {
        if (obj == null || name == null) {
            return false;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Object key : map.keySet()) {
                if (!name.equalsIgnoreCase(key.toString())) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof List) {
            Integer index = IntegerConverter.toNullableInteger(name);
            List list = (List)obj;
            return index != null && index >= 0 && index < list.size();
        }
        if (obj.getClass().isArray()) {
            Integer index = IntegerConverter.toNullableInteger(name);
            int length = Array.getLength(obj);
            return index != null && index >= 0 && index < length;
        }
        return PropertyReflector.hasProperty(obj, name);
    }

    public static Object getProperty(Object obj, String name) {
        if (obj == null || name == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Object key : map.keySet()) {
                if (!name.equalsIgnoreCase(key.toString())) continue;
                return map.get(key);
            }
            return null;
        }
        if (obj instanceof List) {
            Integer index = IntegerConverter.toNullableInteger(name);
            List list = (List)obj;
            return index != null && index >= 0 && index < list.size() ? list.get(index) : null;
        }
        if (obj.getClass().isArray()) {
            Integer index = IntegerConverter.toNullableInteger(name);
            int length = Array.getLength(obj);
            return index != null && index >= 0 && index < length ? Array.get(obj, index) : null;
        }
        return PropertyReflector.getProperty(obj, name);
    }

    public static List<String> getPropertyNames(Object obj) {
        ArrayList<String> properties = new ArrayList<String>();
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    properties.add(entry.getKey().toString());
                }
            } else if (obj instanceof List) {
                List list = (List)obj;
                for (int index = 0; index < list.size(); ++index) {
                    properties.add(Integer.toString(index));
                }
            } else if (obj.getClass().isArray()) {
                int length = Array.getLength(obj);
                for (int index = 0; index < length; ++index) {
                    properties.add(Integer.toString(index));
                }
            } else {
                return PropertyReflector.getPropertyNames(obj);
            }
        }
        return properties;
    }

    public static Map<String, Object> getProperties(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj != null) {
            if (obj instanceof Map) {
                Map mapObj = (Map)obj;
                for (Map.Entry entry : mapObj.entrySet()) {
                    map.put(entry.getKey().toString(), entry.getValue());
                }
            } else if (obj instanceof List) {
                List list = (List)obj;
                for (int index = 0; index < list.size(); ++index) {
                    map.put(Integer.toString(index), list.get(index));
                }
            } else if (obj.getClass().isArray()) {
                int length = Array.getLength(obj);
                for (int index = 0; index < length; ++index) {
                    map.put(Integer.toString(index), Array.get(obj, index));
                }
            } else {
                return PropertyReflector.getProperties(obj);
            }
        }
        return map;
    }
}

