/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZonedDateTime;
import org.pipservices4.commons.convert.BooleanConverter;
import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.DoubleConverter;
import org.pipservices4.commons.convert.DurationConverter;
import org.pipservices4.commons.convert.EnumConverter;
import org.pipservices4.commons.convert.FloatConverter;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.data.AnyValueArray;
import org.pipservices4.commons.data.AnyValueMap;

public class AnyValue
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8543060319681670938L;
    private Object _value;

    public AnyValue() {
        this._value = null;
    }

    public AnyValue(Object value) {
        this._value = value instanceof AnyValue ? ((AnyValue)value)._value : value;
    }

    public AnyValue(AnyValue value) {
        this._value = value.getAsObject();
    }

    @JsonIgnore
    public TypeCode getTypeCode() {
        return TypeConverter.toTypeCode(this._value);
    }

    @JsonProperty(value="value")
    public Object getAsObject() {
        return this._value;
    }

    public <T> T getAsObject(Class<T> objectType) {
        String value = "";
        try {
            if (!(this._value instanceof String)) {
                value = JsonConverter.toJson(this._value);
            }
            return JsonConverter.fromJson(objectType, value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T getAsObject(TypeReference<T> objectType) {
        String value = "";
        try {
            if (!(this._value instanceof String)) {
                value = JsonConverter.toJson(this._value);
            }
            return JsonConverter.fromJson(objectType, value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAsObject(Object value) {
        this._value = value instanceof AnyValue ? ((AnyValue)value)._value : value;
    }

    @JsonIgnore
    public String getAsNullableString() {
        return StringConverter.toNullableString(this._value);
    }

    @JsonIgnore
    public String getAsString() {
        return this.getAsStringWithDefault(null);
    }

    @JsonIgnore
    public String getAsStringWithDefault(String defaultValue) {
        return StringConverter.toStringWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Boolean getAsNullableBoolean() {
        return BooleanConverter.toNullableBoolean(this._value);
    }

    @JsonIgnore
    public Boolean getAsBoolean() {
        return this.getAsBooleanWithDefault(false);
    }

    @JsonIgnore
    public boolean getAsBooleanWithDefault(boolean defaultValue) {
        return BooleanConverter.toBooleanWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Integer getAsNullableInteger() {
        return IntegerConverter.toNullableInteger(this._value);
    }

    @JsonIgnore
    public int getAsInteger() {
        return this.getAsIntegerWithDefault(0);
    }

    @JsonIgnore
    public int getAsIntegerWithDefault(int defaultValue) {
        return IntegerConverter.toIntegerWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Long getAsNullableLong() {
        return LongConverter.toNullableLong(this._value);
    }

    @JsonIgnore
    public long getAsLong() {
        return this.getAsLongWithDefault(0L);
    }

    @JsonIgnore
    public long getAsLongWithDefault(long defaultValue) {
        return LongConverter.toLongWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Float getAsNullableFloat() {
        return FloatConverter.toNullableFloat(this._value);
    }

    @JsonIgnore
    public float getAsFloat() {
        return this.getAsFloatWithDefault(0.0f);
    }

    @JsonIgnore
    public float getAsFloatWithDefault(float defaultValue) {
        return FloatConverter.toFloatWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Double getAsNullableDouble() {
        return DoubleConverter.toNullableDouble(this._value);
    }

    @JsonIgnore
    public double getAsDouble() {
        return this.getAsDoubleWithDefault(0.0);
    }

    @JsonIgnore
    public double getAsDoubleWithDefault(double defaultValue) {
        return DoubleConverter.toDoubleWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public ZonedDateTime getAsNullableDateTime() {
        return DateTimeConverter.toNullableDateTime(this._value);
    }

    @JsonIgnore
    public ZonedDateTime getAsDateTime() {
        return this.getAsDateTimeWithDefault(null);
    }

    @JsonIgnore
    public ZonedDateTime getAsDateTimeWithDefault(ZonedDateTime defaultValue) {
        return DateTimeConverter.toDateTimeWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public Duration getAsNullableDuration() {
        return DurationConverter.toNullableDuration(this._value);
    }

    @JsonIgnore
    public Duration getAsDuration() {
        return this.getAsDurationWithDefault(null);
    }

    @JsonIgnore
    public Duration getAsDurationWithDefault(Duration defaultValue) {
        return DurationConverter.toDurationWithDefault(this._value, defaultValue);
    }

    @JsonIgnore
    public <T extends Enum<T>> T getAsNullableEnum(Class<T> type) {
        return EnumConverter.toNullableEnum(type, this._value);
    }

    @JsonIgnore
    public <T extends Enum<T>> T getAsEnum(Class<T> type) {
        return this.getAsEnumWithDefault(type, null);
    }

    @JsonIgnore
    public <T extends Enum<T>> T getAsEnumWithDefault(Class<T> type, T defaultValue) {
        return EnumConverter.toEnumWithDefault(type, this._value, defaultValue);
    }

    @JsonIgnore
    public <T> T getAsNullableType(Class<T> type) {
        return TypeConverter.toNullableType(type, this._value);
    }

    @JsonIgnore
    public <T> T getAsType(Class<T> type) {
        return this.getAsTypeWithDefault(type, null);
    }

    @JsonIgnore
    public <T> T getAsTypeWithDefault(Class<T> type, T defaultValue) {
        return TypeConverter.toTypeWithDefault(type, this._value, defaultValue);
    }

    @JsonIgnore
    public AnyValueArray getAsArray() {
        return AnyValueArray.fromValue(this._value);
    }

    @JsonIgnore
    public AnyValueMap getAsMap() {
        return AnyValueMap.fromValue(this._value);
    }

    public boolean equals(Object obj) {
        if (obj == null && this._value == null) {
            return true;
        }
        if (obj == null || this._value == null) {
            return false;
        }
        if (obj instanceof AnyValue) {
            obj = ((AnyValue)obj)._value;
        }
        if (this._value == null && obj == null) {
            return true;
        }
        if (this._value == null || obj == null) {
            return false;
        }
        return this._value.equals(obj);
    }

    public <T> boolean equalsAsType(Class<T> type, Object obj) {
        if (obj == null && this._value == null) {
            return true;
        }
        if (obj == null || this._value == null) {
            return false;
        }
        if (obj instanceof AnyValue) {
            obj = ((AnyValue)obj)._value;
        }
        T typedThisValue = TypeConverter.toType(type, this._value);
        T typedValue = TypeConverter.toType(type, obj);
        if (typedThisValue == null && typedValue == null) {
            return true;
        }
        if (typedThisValue == null || typedValue == null) {
            return false;
        }
        return typedThisValue.equals(typedValue);
    }

    public Object clone() {
        return new AnyValue(this._value);
    }

    public String toString() {
        return StringConverter.toString(this._value);
    }

    public int hashCode() {
        return this._value != null ? this._value.hashCode() : 0;
    }
}

