/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.reflect.ObjectReader;

public class RecursiveObjectReader {
    private static boolean performHasProperty(Object obj, String[] names, int nameIndex) {
        if (nameIndex < names.length - 1) {
            Object value = ObjectReader.getProperty(obj, names[nameIndex]);
            if (value != null) {
                return RecursiveObjectReader.performHasProperty(value, names, nameIndex + 1);
            }
            return false;
        }
        return ObjectReader.hasProperty(obj, names[nameIndex]);
    }

    public static boolean hasProperty(Object obj, String name) {
        if (obj == null || name == null) {
            return false;
        }
        String[] names = name.split("\\.");
        if (names.length == 0) {
            return false;
        }
        return RecursiveObjectReader.performHasProperty(obj, names, 0);
    }

    private static Object performGetProperty(Object obj, String[] names, int nameIndex) {
        if (nameIndex < names.length - 1) {
            Object value = ObjectReader.getProperty(obj, names[nameIndex]);
            if (value != null) {
                return RecursiveObjectReader.performGetProperty(value, names, nameIndex + 1);
            }
            return null;
        }
        return ObjectReader.getProperty(obj, names[nameIndex]);
    }

    public static Object getProperty(Object obj, String name) {
        if (obj == null || name == null) {
            return null;
        }
        String[] names = name.split("\\.");
        if (names.length == 0) {
            return null;
        }
        return RecursiveObjectReader.performGetProperty(obj, names, 0);
    }

    private static boolean isSimpleValue(Object value) {
        TypeCode code = TypeConverter.toTypeCode(value);
        return code != TypeCode.Array && code != TypeCode.Map && code != TypeCode.Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performGetPropertyNames(Object obj, String path, List<String> result, List<Object> cycleDetect) {
        Map<String, Object> map = ObjectReader.getProperties(obj);
        if (map.size() != 0 && cycleDetect.size() < 100) {
            cycleDetect.add(obj);
            try {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String key;
                    Object value = entry.getValue();
                    if (cycleDetect.contains(value)) continue;
                    String string = key = path != null ? path + "." + entry.getKey() : entry.getKey();
                    if (RecursiveObjectReader.isSimpleValue(value)) {
                        result.add(key);
                        continue;
                    }
                    RecursiveObjectReader.performGetPropertyNames(value, key, result, cycleDetect);
                }
            }
            finally {
                cycleDetect.remove(obj);
            }
        } else if (path != null) {
            result.add(path);
        }
    }

    public static List<String> getPropertyNames(Object obj) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (obj != null) {
            ArrayList<Object> cycleDetect = new ArrayList<Object>();
            RecursiveObjectReader.performGetPropertyNames(obj, null, propertyNames, cycleDetect);
        }
        return propertyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performGetProperties(Object obj, String path, Map<String, Object> result, List<Object> cycleDetect) {
        Map<String, Object> map = ObjectReader.getProperties(obj);
        if (map.size() != 0 && cycleDetect.size() < 100) {
            cycleDetect.add(obj);
            try {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String key;
                    Object value = entry.getValue();
                    if (cycleDetect.contains(value)) continue;
                    String string = key = path != null ? path + "." + entry.getKey() : entry.getKey();
                    if (RecursiveObjectReader.isSimpleValue(value)) {
                        result.put(key, value);
                        continue;
                    }
                    RecursiveObjectReader.performGetProperties(value, key, result, cycleDetect);
                }
            }
            finally {
                cycleDetect.remove(obj);
            }
        } else if (path != null) {
            result.put(path, obj);
        }
    }

    public static Map<String, Object> getProperties(Object obj) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (obj != null) {
            ArrayList<Object> cycleDetect = new ArrayList<Object>();
            RecursiveObjectReader.performGetProperties(obj, null, properties, cycleDetect);
        }
        return properties;
    }
}

