/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import org.pipservices4.commons.convert.BooleanConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.commons.data.StringValueMap;

public class PagingParams {
    private Long _skip;
    private Long _take;
    private boolean _total;

    public PagingParams() {
    }

    public PagingParams(Object skip, Object take, Object total) {
        this._skip = LongConverter.toNullableLong(skip);
        this._take = LongConverter.toNullableLong(take);
        this._total = BooleanConverter.toBooleanWithDefault(total, false);
        if (this._take != null && this._take == 0L) {
            this._take = null;
        }
    }

    public Long getSkip() {
        return this._skip;
    }

    public long getSkip(long minSkip) {
        if (this._skip == null) {
            return minSkip;
        }
        if (this._skip < minSkip) {
            return minSkip;
        }
        return this._skip;
    }

    public Long getTake() {
        return this._take;
    }

    public void setSkip(long value) {
        this._skip = value;
    }

    public long getTake(long maxTake) {
        if (this._take == null) {
            return maxTake;
        }
        if (this._take < 0L) {
            return 0L;
        }
        if (this._take > maxTake) {
            return maxTake;
        }
        return this._take;
    }

    public void setTake(long value) {
        this._take = value;
    }

    public boolean hasTotal() {
        return this._total;
    }

    public void setTotal(boolean value) {
        this._total = value;
    }

    public static PagingParams fromValue(Object value) {
        if (value instanceof PagingParams) {
            return (PagingParams)value;
        }
        AnyValueMap map = AnyValueMap.fromValue(value);
        return PagingParams.fromMap(map);
    }

    public static PagingParams fromTuples(Object ... tuples) {
        AnyValueMap map = AnyValueMap.fromTuples(tuples);
        return PagingParams.fromMap(map);
    }

    public static PagingParams fromMap(AnyValueMap map) {
        Long skip = map.getAsNullableLong("skip");
        Long take = map.getAsNullableLong("take");
        boolean total = map.getAsBooleanWithDefault("total", false);
        return new PagingParams(skip, take, total);
    }

    public static PagingParams fromMap(StringValueMap map) {
        Long skip = map.getAsNullableLong("skip");
        Long take = map.getAsNullableLong("take");
        boolean total = map.getAsBooleanWithDefault("total", true);
        return new PagingParams(skip, take, total);
    }
}

