/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.BooleanConverter;
import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.DoubleConverter;
import org.pipservices4.commons.convert.DurationConverter;
import org.pipservices4.commons.convert.EnumConverter;
import org.pipservices4.commons.convert.FloatConverter;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.convert.MapConverter;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.data.AnyValue;
import org.pipservices4.commons.data.AnyValueArray;
import org.pipservices4.commons.data.ICloneable;

public class AnyValueMap
extends HashMap<String, Object>
implements ICloneable {
    private static final long serialVersionUID = 5876557837753631885L;

    public AnyValueMap() {
    }

    public AnyValueMap(Map<?, ?> values) {
        this.append(values);
    }

    public Object get(String key) {
        return super.get(key);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keySet());
    }

    public void append(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = StringConverter.toString(entry.getKey());
            Object value = entry.getValue();
            super.put(key, value);
        }
    }

    public Object getAsObject() {
        return new HashMap<String, Object>(this);
    }

    public void setAsObject(Object value) {
        this.clear();
        Map<String, Object> values = MapConverter.toMap(value);
        this.append(values);
    }

    public int length() {
        return this.size();
    }

    public Object getAsObject(String key) {
        return this.get(key);
    }

    public <T> T getAsObject(Class<T> objectType, String key) {
        String strValue = "";
        Object value = this.get(key);
        try {
            if (!(value instanceof String)) {
                strValue = JsonConverter.toJson(value);
            }
            return JsonConverter.fromJson(objectType, strValue);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T getAsObject(TypeReference<T> objectType, String key) {
        String strValue = "";
        Object value = this.get(key);
        try {
            if (!(value instanceof String)) {
                strValue = JsonConverter.toJson(value);
            }
            return JsonConverter.fromJson(objectType, strValue);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAsObject(String key, Object value) {
        this.put(key, value);
    }

    public String getAsNullableString(String key) {
        Object value = this.getAsObject(key);
        return StringConverter.toNullableString(value);
    }

    public String getAsString(String key) {
        return this.getAsStringWithDefault(key, null);
    }

    public String getAsStringWithDefault(String key, String defaultValue) {
        Object value = this.getAsObject(key);
        return StringConverter.toStringWithDefault(value, defaultValue);
    }

    public Boolean getAsNullableBoolean(String key) {
        Object value = this.getAsObject(key);
        return BooleanConverter.toNullableBoolean(value);
    }

    public boolean getAsBoolean(String key) {
        return this.getAsBooleanWithDefault(key, false);
    }

    public boolean getAsBooleanWithDefault(String key, boolean defaultValue) {
        Object value = this.getAsObject(key);
        return BooleanConverter.toBooleanWithDefault(value, defaultValue);
    }

    public Integer getAsNullableInteger(String key) {
        Object value = this.getAsObject(key);
        return IntegerConverter.toNullableInteger(value);
    }

    public int getAsInteger(String key) {
        return this.getAsIntegerWithDefault(key, 0);
    }

    public int getAsIntegerWithDefault(String key, int defaultValue) {
        Object value = this.getAsObject(key);
        return IntegerConverter.toIntegerWithDefault(value, defaultValue);
    }

    public Long getAsNullableLong(String key) {
        Object value = this.getAsObject(key);
        return LongConverter.toNullableLong(value);
    }

    public long getAsLong(String key) {
        return this.getAsLongWithDefault(key, 0L);
    }

    public long getAsLongWithDefault(String key, long defaultValue) {
        Object value = this.getAsObject(key);
        return LongConverter.toLongWithDefault(value, defaultValue);
    }

    public Float getAsNullableFloat(String key) {
        Object value = this.getAsObject(key);
        return FloatConverter.toNullableFloat(value);
    }

    public float getAsFloat(String key) {
        return this.getAsFloatWithDefault(key, 0.0f);
    }

    public float getAsFloatWithDefault(String key, float defaultValue) {
        Object value = this.getAsObject(key);
        return FloatConverter.toFloatWithDefault(value, defaultValue);
    }

    public Double getAsNullableDouble(String key) {
        Object value = this.getAsObject(key);
        return DoubleConverter.toNullableDouble(value);
    }

    public double getAsDouble(String key) {
        return this.getAsDoubleWithDefault(key, 0.0);
    }

    public double getAsDoubleWithDefault(String key, double defaultValue) {
        Object value = this.getAsObject(key);
        return DoubleConverter.toDoubleWithDefault(value, defaultValue);
    }

    public ZonedDateTime getAsNullableDateTime(String key) {
        Object value = this.getAsObject(key);
        return DateTimeConverter.toNullableDateTime(value);
    }

    public ZonedDateTime getAsDateTime(String key) {
        return this.getAsDateTimeWithDefault(key, null);
    }

    public ZonedDateTime getAsDateTimeWithDefault(String key, ZonedDateTime defaultValue) {
        Object value = this.getAsObject(key);
        return DateTimeConverter.toDateTimeWithDefault(value, defaultValue);
    }

    public Duration getAsNullableDuration(String key) {
        Object value = this.getAsObject(key);
        return DurationConverter.toNullableDuration(value);
    }

    public Duration getAsDuration(String key) {
        return this.getAsDurationWithDefault(key, null);
    }

    public Duration getAsDurationWithDefault(String key, Duration defaultValue) {
        Object value = this.getAsObject(key);
        return DurationConverter.toDurationWithDefault(value, defaultValue);
    }

    public <T extends Enum<T>> T getAsNullableEnum(Class<T> type, String key) {
        Object value = this.getAsObject(key);
        return EnumConverter.toNullableEnum(type, value);
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> type, String key) {
        return this.getAsEnumWithDefault(type, key, null);
    }

    public <T extends Enum<T>> T getAsEnumWithDefault(Class<T> type, String key, T defaultValue) {
        Object value = this.getAsObject(key);
        return EnumConverter.toEnumWithDefault(type, value, defaultValue);
    }

    public <T> T getAsNullableType(Class<T> type, String key) {
        Object value = this.getAsObject(key);
        return TypeConverter.toNullableType(type, value);
    }

    public <T> T getAsType(Class<T> type, String key) {
        return this.getAsTypeWithDefault(type, key, null);
    }

    public <T> T getAsTypeWithDefault(Class<T> type, String key, T defaultValue) {
        Object value = this.getAsObject(key);
        return TypeConverter.toTypeWithDefault(type, value, defaultValue);
    }

    public AnyValue getAsValue(String key) {
        Object value = this.getAsObject(key);
        return new AnyValue(value);
    }

    public AnyValueArray getAsNullableArray(String key) {
        Object value = this.getAsObject(key);
        return value != null ? AnyValueArray.fromValue(value) : null;
    }

    public AnyValueArray getAsArray(String key) {
        Object value = this.getAsObject(key);
        return AnyValueArray.fromValue(value);
    }

    public AnyValueArray getAsArrayWithDefault(String key, AnyValueArray defaultValue) {
        AnyValueArray result = this.getAsNullableArray(key);
        return result != null ? result : defaultValue;
    }

    public AnyValueMap getAsNullableMap(String key) {
        Object value = this.getAsObject(key);
        return value != null ? AnyValueMap.fromValue(value) : null;
    }

    public AnyValueMap getAsMap(String key) {
        Object value = this.getAsObject(key);
        return AnyValueMap.fromValue(value);
    }

    public AnyValueMap getAsMapWithDefault(String key, AnyValueMap defaultValue) {
        AnyValueMap result = this.getAsNullableMap(key);
        return result != null ? result : defaultValue;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            if (entry.getValue() != null) {
                builder.append((String)entry.getKey()).append('=').append(entry.getValue());
                continue;
            }
            builder.append((String)entry.getKey());
        }
        return builder.toString();
    }

    @Override
    public Object clone() {
        return new AnyValueMap((Map<?, ?>)this);
    }

    public static AnyValueMap fromValue(Object value) {
        AnyValueMap result = new AnyValueMap();
        result.setAsObject(value);
        return result;
    }

    public static AnyValueMap fromTuples(Object ... tuples) {
        return AnyValueMap.fromTuplesArray(tuples);
    }

    public static AnyValueMap fromTuplesArray(Object[] tuples) {
        AnyValueMap result = new AnyValueMap();
        if (tuples == null || tuples.length == 0) {
            return result;
        }
        for (int index = 0; index < tuples.length && index + 1 < tuples.length; index += 2) {
            String name = StringConverter.toString(tuples[index]);
            Object value = tuples[index + 1];
            result.setAsObject(name, value);
        }
        return result;
    }

    public static AnyValueMap fromMaps(Map<?, ?> ... maps) {
        AnyValueMap result = new AnyValueMap();
        if (maps == null || maps.length == 0) {
            return result;
        }
        for (Map<?, ?> map : maps) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String key = StringConverter.toString(entry.getKey());
                Object value = entry.getValue();
                result.put(key, value);
            }
        }
        return result;
    }
}

