/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;
import java.util.Calendar;
import java.util.Date;

public class LongConverter {
    public static Long toNullableLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof Duration) {
            return ((Duration)value).toMillis();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof Short) {
            return (long)((Short)value);
        }
        if (value instanceof Long) {
            return (long)((Long)value);
        }
        if (value instanceof Float) {
            return Math.round(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Math.round((Double)value);
        }
        if (value instanceof String) {
            try {
                return Math.round(Double.parseDouble((String)value));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static long toLong(Object value) {
        return LongConverter.toLongWithDefault(value, 0L);
    }

    public static long toLongWithDefault(Object value, long defaultValue) {
        Long result = LongConverter.toNullableLong(value);
        return result != null ? result : defaultValue;
    }
}

