/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;

public class DateTimeConverter {
    private static final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter simpleDateFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");

    private static ZonedDateTime millisToDateTime(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static ZonedDateTime toNullableDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof Date) {
            return ZonedDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof LocalDate) {
            return ZonedDateTime.of((LocalDate)value, LocalTime.of(0, 0), ZoneId.systemDefault());
        }
        if (value instanceof LocalDateTime) {
            return ZonedDateTime.of((LocalDateTime)value, ZoneId.systemDefault());
        }
        if (value instanceof Integer) {
            return DateTimeConverter.millisToDateTime(((Integer)value).intValue());
        }
        if (value instanceof Short) {
            return DateTimeConverter.millisToDateTime(((Short)value).shortValue());
        }
        if (value instanceof Long) {
            return DateTimeConverter.millisToDateTime((Long)value);
        }
        if (value instanceof Float) {
            return DateTimeConverter.millisToDateTime((long)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DateTimeConverter.millisToDateTime((long)((Double)value).doubleValue());
        }
        if (value instanceof Duration) {
            return DateTimeConverter.millisToDateTime(((Duration)value).toMillis());
        }
        if (value instanceof String) {
            try {
                return ZonedDateTime.parse((String)value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return ZonedDateTime.of(LocalDateTime.parse((String)value, simpleDateTimeFormatter), ZoneId.systemDefault());
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    try {
                        return ZonedDateTime.of(LocalDate.parse((String)value, simpleDateFormatter), LocalTime.of(0, 0), ZoneId.systemDefault());
                    }
                    catch (DateTimeParseException dateTimeParseException3) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static ZonedDateTime toDateTime(Object value) {
        return DateTimeConverter.toDateTimeWithDefault(value, null);
    }

    public static ZonedDateTime toDateTimeWithDefault(Object value, ZonedDateTime defaultValue) {
        ZonedDateTime result = DateTimeConverter.toNullableDateTime(value);
        return result != null ? result : defaultValue;
    }
}

