package org.pipservices4.commons.data;

/**
 * Interface for data objects that can be uniquely identifed by a string id.
 * <p>
 * The interface extends {@link IIdentifiable} to hardcode id type to string.
 * <p>
 * It is a common pattern to use a string GUID as the id, generated by {@link IdGenerator}.
 * <p>
 * ### Example ###
 * <pre>
 * {@code
 *  public class MyData implements IStringIdentifiable {
 *    private String id;
 *    public String field1;
 *    public int field2;
 *    ...
 *    public String getId() {...}
 *    public void setId(String newId) {...}
 *  }
 *  }
 *  </pre>
 *
 * @see IIdentifiable
 * @see IdGenerator
 */
public interface IStringIdentifiable extends IIdentifiable<String> {
}
