/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pipservices4.commons.convert.StringConverter;

public class MapConverter {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    private static Map<String, Object> listToMap(Collection<Object> list) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int index = 0;
        for (Object item : list) {
            result.put(Integer.toString(index), item);
            ++index;
        }
        return result;
    }

    private static Map<String, Object> arrayToMap(Object[] array) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int index = 0;
        for (Object item : array) {
            result.put(Integer.toString(index), item);
            ++index;
        }
        return result;
    }

    private static Map<String, Object> mapToMap(Map<Object, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            result.put(StringConverter.toString(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> toNullableMap(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isPrimitive()) {
            return null;
        }
        if (value instanceof Map) {
            return MapConverter.mapToMap((Map)value);
        }
        if (valueClass.isArray()) {
            return MapConverter.arrayToMap((Object[])value);
        }
        if (value instanceof Collection) {
            return MapConverter.listToMap((Collection)value);
        }
        try {
            return mapper.convertValue(value, typeRef);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Map<String, Object> toMap(Object value) {
        HashMap result = MapConverter.toNullableMap(value);
        return result != null ? result : new HashMap();
    }

    public static Map<String, Object> toMapWithDefault(Object value, Map<String, Object> defaultValue) {
        Map<String, Object> result = MapConverter.toNullableMap(value);
        return result != null ? result : defaultValue;
    }
}

