/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ArrayConverter {
    public static List<Object> toNullableArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> array = new ArrayList<Object>();
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                array.add(Array.get(value, index));
            }
            return array;
        }
        if (value instanceof Map) {
            ArrayList<Object> array = new ArrayList<Object>();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                array.add(entry.getValue());
            }
            return array;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(value);
        return array;
    }

    public static List<Object> toArray(Object value) {
        ArrayList result = ArrayConverter.toNullableArray(value);
        return result != null ? result : new ArrayList();
    }

    public static List<Object> toArrayWithDefault(Object value, List<Object> defaultValue) {
        List<Object> result = ArrayConverter.toNullableArray(value);
        return result != null ? result : defaultValue;
    }

    public static List<Object> listToArray(Object value) {
        if (value == null) {
            return new ArrayList<Object>();
        }
        if (value instanceof String) {
            value = ((String)value).split(",");
        }
        return ArrayConverter.toArray(value);
    }
}

