/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.errors;

import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.BadRequestException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ConflictException;
import org.pipservices4.commons.errors.ConnectionException;
import org.pipservices4.commons.errors.ErrorDescription;
import org.pipservices4.commons.errors.FileException;
import org.pipservices4.commons.errors.InternalException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.commons.errors.NotFoundException;
import org.pipservices4.commons.errors.UnauthorizedException;
import org.pipservices4.commons.errors.UnknownException;
import org.pipservices4.commons.errors.UnsupportedException;

public class ApplicationExceptionFactory {
    public static ApplicationException create(ErrorDescription description) {
        if (description == null) {
            throw new NullPointerException("Description cannot be null");
        }
        ApplicationException error = null;
        String category = description.getCategory();
        String code = description.getCode();
        String message = description.getMessage();
        String correlationId = description.getCorrelationId();
        if ("Unknown".equals(category)) {
            error = new UnknownException(correlationId, code, message);
        } else if ("Internal".equals(category)) {
            error = new InternalException(correlationId, code, message);
        } else if ("Misconfiguration".equals(category)) {
            error = new ConfigException(correlationId, code, message);
        } else if ("NoResponse".equals(category)) {
            error = new ConnectionException(correlationId, code, message);
        } else if ("FailedInvocation".equals(category)) {
            error = new InvocationException(correlationId, code, message);
        } else if ("FileError".equals(category)) {
            error = new FileException(correlationId, code, message);
        } else if ("BadRequest".equals(category)) {
            error = new BadRequestException(correlationId, code, message);
        } else if ("Unauthorized".equals(category)) {
            error = new UnauthorizedException(correlationId, code, message);
        } else if ("Conflict".equals(category)) {
            error = new ConflictException(correlationId, code, message);
        } else if ("NotFound".equals(category)) {
            error = new NotFoundException(correlationId, code, message);
        } else if ("InvalidState".equals(category)) {
            error = new InvalidStateException(correlationId, code, message);
        } else if ("Unsupported".equals(category)) {
            error = new UnsupportedException(correlationId, code, message);
        } else {
            error = new UnknownException();
            error.setCategory(category);
            error.setStatus(description.getStatus());
        }
        error.setDetails(description.getDetails());
        error.setCauseString(description.getCause());
        error.setStackTraceString(description.getStackTrace());
        return error;
    }
}

