/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.commons.reflect.PropertyReflector;

public class TagsProcessor {
    private static final String NORMALIZE_REGEX = "[_#]+";
    private static final String COMPRESS_REGEX = "[ _#]+";
    private static final String SPLIT_REGEX = "[,;]+";
    private static final String HASHTAG_REGEX = "#\\w+";

    public static String normalizeTag(String tag) {
        return tag != null ? tag.replaceAll(NORMALIZE_REGEX, " ").trim() : null;
    }

    public static String compressTag(String tag) {
        return tag != null ? tag.replaceAll(COMPRESS_REGEX, "").toLowerCase(Locale.ROOT) : null;
    }

    public static Boolean equalTags(String tag1, String tag2) {
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        return Objects.equals(TagsProcessor.compressTag(tag1), TagsProcessor.compressTag(tag2));
    }

    public static List<String> normalizeTags(List<String> tags) {
        ArrayList<String> normalizedTags = new ArrayList<String>();
        for (String tag : tags) {
            normalizedTags.add(TagsProcessor.normalizeTag(tag));
        }
        return normalizedTags;
    }

    public static List<String> normalizeTagList(String tagList) {
        List<String> tags = List.of(tagList.split(SPLIT_REGEX, -1));
        return TagsProcessor.normalizeTags(tags);
    }

    public static List<String> compressTags(List<String> tags) {
        ArrayList<String> compressedTags = new ArrayList<String>();
        for (String tag : tags) {
            compressedTags.add(TagsProcessor.compressTag(tag));
        }
        return compressedTags;
    }

    public static List<String> compressTagList(String tagList) {
        List<String> tags = List.of(tagList.split(SPLIT_REGEX, -1));
        return TagsProcessor.compressTags(tags);
    }

    public static List<String> extractHashTags(String text) {
        List<String> tags = new ArrayList<String>();
        Matcher m = Pattern.compile(HASHTAG_REGEX).matcher(text);
        if (!text.isEmpty()) {
            while (m.find()) {
                tags.add(m.group());
            }
        }
        tags = TagsProcessor.compressTags(tags);
        return new ArrayList<String>(new HashSet<String>(tags));
    }

    private static String extractString(Object field) {
        StringBuilder result = new StringBuilder();
        if (field == null) {
            return "";
        }
        if (field instanceof String) {
            return (String)field;
        }
        if (field instanceof Map) {
            for (Object prop : ((Map)field).keySet()) {
                result.append(" ").append(TagsProcessor.extractString(((Map)field).get(prop)));
            }
            return result.toString();
        }
        if (!(field instanceof Iterable)) {
            return "";
        }
        Map<String, Object> properties = PropertyReflector.getProperties(field);
        for (String prop : properties.keySet()) {
            result.append(" ").append(TagsProcessor.extractString(properties.get(prop)));
        }
        return result.toString();
    }

    public static List<String> extractHashTagsFromValue(Object obj, List<String> searchFields) {
        List value = (List)ObjectReader.getProperty(obj, "tags");
        List<String> tags = TagsProcessor.compressTags(value);
        for (String field : searchFields) {
            String text = obj instanceof Map ? TagsProcessor.extractString(((Map)obj).get(field)) : TagsProcessor.extractString(PropertyReflector.getProperty(obj, field));
            if (text.isEmpty()) continue;
            ArrayList<String> matchTags = new ArrayList<String>();
            Matcher m = Pattern.compile(HASHTAG_REGEX).matcher(text);
            while (m.find()) {
                matchTags.add(m.group());
            }
            tags.addAll(TagsProcessor.compressTags(matchTags));
        }
        return new ArrayList<String>(new HashSet<String>(tags));
    }
}

