/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.convert.BooleanConverter;
import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.DoubleConverter;
import org.pipservices4.commons.convert.DurationConverter;
import org.pipservices4.commons.convert.EnumConverter;
import org.pipservices4.commons.convert.FloatConverter;
import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.LongConverter;
import org.pipservices4.commons.convert.MapConverter;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.data.AnyValue;
import org.pipservices4.commons.data.AnyValueArray;
import org.pipservices4.commons.data.AnyValueMap;
import org.pipservices4.commons.data.ICloneable;

public class StringValueMap
extends HashMap<String, String>
implements ICloneable {
    private static final long serialVersionUID = -7743560121354524782L;

    public StringValueMap() {
    }

    public StringValueMap(Map<?, ?> map) {
        this.append(map);
    }

    public String get(String key) {
        return (String)super.get(key);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keySet());
    }

    @Override
    public void put(String key, Object value) {
        this.put(key, StringConverter.toNullableString(value));
    }

    public void append(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.put(StringConverter.toString(entry.getKey()), StringConverter.toNullableString(entry.getValue()));
        }
    }

    public int length() {
        return this.size();
    }

    public Object getAsObject() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.entrySet()) {
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void setAsObject(Object value) {
        this.clear();
        Map<String, Object> values = MapConverter.toMap(value);
        this.append(values);
    }

    public Object getAsObject(String key) {
        return this.get(key);
    }

    public void setAsObject(String key, Object value) {
        this.put(key, StringConverter.toNullableString(value));
    }

    public String getAsNullableString(String key) {
        Object value = this.getAsObject(key);
        return StringConverter.toNullableString(value);
    }

    public String getAsString(String key) {
        return this.getAsStringWithDefault(key, null);
    }

    public String getAsStringWithDefault(String key, String defaultValue) {
        Object value = this.getAsObject(key);
        return StringConverter.toStringWithDefault(value, defaultValue);
    }

    public Boolean getAsNullableBoolean(String key) {
        Object value = this.getAsObject(key);
        return BooleanConverter.toNullableBoolean(value);
    }

    public boolean getAsBoolean(String key) {
        return this.getAsBooleanWithDefault(key, false);
    }

    public boolean getAsBooleanWithDefault(String key, boolean defaultValue) {
        Object value = this.getAsObject(key);
        return BooleanConverter.toBooleanWithDefault(value, defaultValue);
    }

    public Integer getAsNullableInteger(String key) {
        Object value = this.getAsObject(key);
        return IntegerConverter.toNullableInteger(value);
    }

    public int getAsInteger(String key) {
        return this.getAsIntegerWithDefault(key, 0);
    }

    public int getAsIntegerWithDefault(String key, int defaultValue) {
        Object value = this.getAsObject(key);
        return IntegerConverter.toIntegerWithDefault(value, defaultValue);
    }

    public Long getAsNullableLong(String key) {
        Object value = this.getAsObject(key);
        return LongConverter.toNullableLong(value);
    }

    public long getAsLong(String key) {
        return this.getAsLongWithDefault(key, 0L);
    }

    public long getAsLongWithDefault(String key, long defaultValue) {
        Object value = this.getAsObject(key);
        return LongConverter.toLongWithDefault(value, defaultValue);
    }

    public Float getAsNullableFloat(String key) {
        Object value = this.getAsObject(key);
        return FloatConverter.toNullableFloat(value);
    }

    public float getAsFloat(String key) {
        return this.getAsFloatWithDefault(key, 0.0f);
    }

    public float getAsFloatWithDefault(String key, float defaultValue) {
        Object value = this.getAsObject(key);
        return FloatConverter.toFloatWithDefault(value, defaultValue);
    }

    public Double getAsNullableDouble(String key) {
        Object value = this.getAsObject(key);
        return DoubleConverter.toNullableDouble(value);
    }

    public double getAsDouble(String key) {
        return this.getAsDoubleWithDefault(key, 0.0);
    }

    public double getAsDoubleWithDefault(String key, double defaultValue) {
        Object value = this.getAsObject(key);
        return DoubleConverter.toDoubleWithDefault(value, defaultValue);
    }

    public ZonedDateTime getAsNullableDateTime(String key) {
        Object value = this.getAsObject(key);
        return DateTimeConverter.toNullableDateTime(value);
    }

    public ZonedDateTime getAsDateTime(String key) {
        return this.getAsDateTimeWithDefault(key, null);
    }

    public ZonedDateTime getAsDateTimeWithDefault(String key, ZonedDateTime defaultValue) {
        Object value = this.getAsObject(key);
        return DateTimeConverter.toDateTimeWithDefault(value, defaultValue);
    }

    public Duration getAsNullableDuration(String key) {
        Object value = this.getAsObject(key);
        return DurationConverter.toNullableDuration(value);
    }

    public Duration getAsDuration(String key) {
        return this.getAsDurationWithDefault(key, null);
    }

    public Duration getAsDurationWithDefault(String key, Duration defaultValue) {
        Object value = this.getAsObject(key);
        return DurationConverter.toDurationWithDefault(value, defaultValue);
    }

    public <T extends Enum<T>> T getAsNullableEnum(Class<T> type, String key) {
        Object value = this.getAsObject(key);
        return EnumConverter.toNullableEnum(type, value);
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> type, String key) {
        return this.getAsEnumWithDefault(type, key, null);
    }

    public <T extends Enum<T>> T getAsEnumWithDefault(Class<T> type, String key, T defaultValue) {
        Object value = this.getAsObject(key);
        return EnumConverter.toEnumWithDefault(type, value, defaultValue);
    }

    public <T> T getAsNullableType(Class<T> type, String key) {
        Object value = this.getAsObject(key);
        return TypeConverter.toNullableType(type, value);
    }

    public <T> T getAsType(Class<T> type, String key) {
        return this.getAsTypeWithDefault(type, key, null);
    }

    public <T> T getAsTypeWithDefault(Class<T> type, String key, T defaultValue) {
        Object value = this.getAsObject(key);
        return TypeConverter.toTypeWithDefault(type, value, defaultValue);
    }

    public AnyValue getAsValue(String key) {
        Object value = this.getAsObject(key);
        return new AnyValue(value);
    }

    public AnyValueArray getAsNullableArray(String key) {
        Object value = this.getAsObject(key);
        return value != null ? AnyValueArray.fromValue(value) : null;
    }

    public AnyValueArray getAsArray(String key) {
        Object value = this.getAsObject(key);
        return AnyValueArray.fromValue(value);
    }

    public AnyValueArray getAsArrayWithDefault(String key, AnyValueArray defaultValue) {
        AnyValueArray result = this.getAsNullableArray(key);
        return result != null ? result : defaultValue;
    }

    public AnyValueMap getAsNullableMap(String key) {
        Object value = this.getAsObject(key);
        return value != null ? AnyValueMap.fromValue(value) : null;
    }

    public AnyValueMap getAsMap(String key) {
        Object value = this.getAsObject(key);
        return AnyValueMap.fromValue(value);
    }

    public AnyValueMap getAsMapWithDefault(String key, AnyValueMap defaultValue) {
        AnyValueMap result = this.getAsNullableMap(key);
        return result != null ? result : defaultValue;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            if (entry.getValue() != null) {
                builder.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                continue;
            }
            builder.append((String)entry.getKey());
        }
        return builder.toString();
    }

    @Override
    public StringValueMap clone() {
        return new StringValueMap((Map<?, ?>)this);
    }

    public static StringValueMap fromTuples(Object ... tuples) {
        return StringValueMap.fromTuplesArray(tuples);
    }

    public static StringValueMap fromTuplesArray(Object[] tuples) {
        StringValueMap result = new StringValueMap();
        if (tuples == null || tuples.length == 0) {
            return result;
        }
        int index = 0;
        while (index < tuples.length) {
            if (index + 1 >= tuples.length) break;
            String name = StringConverter.toString(tuples[index]);
            String value = StringConverter.toNullableString(tuples[index + 1]);
            result.put(name, value);
            index += 2;
        }
        return result;
    }

    public static StringValueMap fromString(String line) {
        String[] tokens;
        StringValueMap result = new StringValueMap();
        if (line == null || line.length() == 0) {
            return result;
        }
        String[] stringArray = tokens = line.split(";", -1);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() != 0) {
                int index = token.indexOf(61);
                String key = index > 0 ? token.substring(0, index).trim() : token.trim();
                String val = index > 0 ? token.substring(index + 1).trim() : null;
                result.put(key, val);
            }
            ++n2;
        }
        return result;
    }

    public static StringValueMap fromMaps(Map<?, ?> ... maps) {
        StringValueMap result = new StringValueMap();
        if (maps != null && maps.length > 0) {
            Map<?, ?>[] mapArray = maps;
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<?, ?> map = mapArray[n2];
                result.append(map);
                ++n2;
            }
        }
        return result;
    }
}

