/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pipservices4.commons.data.AnyValueArray;

public class ProjectionParams
extends ArrayList<String> {
    private static final long serialVersionUID = 5876557837753631885L;
    private static char defaultDelimiter = (char)44;

    public ProjectionParams() {
    }

    public ProjectionParams(String[] values) {
        if (values != null) {
            this.addAll(Arrays.asList(values));
        }
    }

    public ProjectionParams(AnyValueArray array) {
        if (array == null) {
            return;
        }
        for (int index = 0; index < array.size(); ++index) {
            String value = array.getAsString(index);
            if (value == null || value.length() <= 0) continue;
            this.add(value);
        }
    }

    public static ProjectionParams fromValue(Object value) {
        if (value instanceof ProjectionParams) {
            return (ProjectionParams)value;
        }
        AnyValueArray array = value != null ? AnyValueArray.fromValue(value) : new AnyValueArray();
        return new ProjectionParams(array);
    }

    public static ProjectionParams fromValues(String ... values) {
        return ProjectionParams.fromValues(defaultDelimiter, values);
    }

    public static ProjectionParams fromValues(char delimiter, String ... values) {
        return new ProjectionParams(ProjectionParams.parse(delimiter, values));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < this.size(); ++index) {
            if (index > 0) {
                builder.append(',');
            }
            builder.append((String)super.get(index));
        }
        return builder.toString();
    }

    private static String[] parse(char delimiter, String[] values) {
        ArrayList<String> result = new ArrayList<String>();
        String prefix = "";
        for (String value : values) {
            ProjectionParams.parseValue(prefix, result, value.trim(), delimiter);
        }
        return result.toArray(new String[result.size()]);
    }

    private static void parseValue(String prefix, List<String> result, String value, char delimiter) {
        value = value.trim();
        int openBracket = 0;
        int openBracketIndex = -1;
        int closeBracketIndex = -1;
        int commaIndex = -1;
        boolean breakCycleRequired = false;
        for (int index = 0; index < value.length(); ++index) {
            Character valueChar = Character.valueOf(value.charAt(index));
            if (valueChar.equals(Character.valueOf('('))) {
                if (openBracket == 0) {
                    openBracketIndex = index;
                }
                ++openBracket;
            } else if (valueChar.equals(Character.valueOf(')'))) {
                if (--openBracket == 0) {
                    closeBracketIndex = index;
                    if (openBracketIndex >= 0 && closeBracketIndex > 0) {
                        String previousPrefix = prefix;
                        prefix = prefix != null && ((String)prefix).length() > 0 ? (String)prefix + "." + value.substring(0, openBracketIndex) : value.substring(0, openBracketIndex);
                        String subValue = value.substring(openBracketIndex + 1, closeBracketIndex);
                        ProjectionParams.parseValue((String)prefix, result, subValue, delimiter);
                        subValue = value.substring(closeBracketIndex + 1);
                        ProjectionParams.parseValue(previousPrefix, result, subValue, delimiter);
                        breakCycleRequired = true;
                    }
                }
            } else if (valueChar.equals(Character.valueOf(delimiter)) && openBracket == 0) {
                commaIndex = index;
                String subValue = value.substring(0, commaIndex);
                if (subValue != null && subValue.length() > 0) {
                    if (prefix != null && ((String)prefix).length() > 0) {
                        result.add((String)prefix + "." + subValue);
                    } else {
                        result.add(subValue);
                    }
                }
                if ((subValue = value.substring(commaIndex + 1)) != null && subValue.length() > 0) {
                    ProjectionParams.parseValue((String)prefix, result, subValue, delimiter);
                    breakCycleRequired = true;
                }
            }
            if (breakCycleRequired) break;
        }
        if (value != null && value.length() > 0 && openBracketIndex == -1 && commaIndex == -1) {
            if (prefix != null && ((String)prefix).length() > 0) {
                result.add((String)prefix + "." + value);
            } else {
                result.add(value);
            }
        }
    }
}

