/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class StringConverter {
    public static String toNullableString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            value = ZonedDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            value = ZonedDateTime.ofInstant(((Calendar)value).toInstant(), ((Calendar)value).getTimeZone().toZoneId());
        }
        if (value instanceof Duration) {
            value = ((Duration)value).toMillis();
        }
        if (value instanceof Instant) {
            value = ZonedDateTime.ofInstant((Instant)value, ZoneId.systemDefault());
        }
        if (value instanceof LocalDateTime) {
            value = ZonedDateTime.of((LocalDateTime)value, ZoneId.systemDefault());
        }
        if (value instanceof LocalDate) {
            value = ZonedDateTime.of((LocalDate)value, LocalTime.of(0, 0), ZoneId.systemDefault());
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            for (Object element : (List)value) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(element);
            }
            return builder.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder();
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(Array.get(value, index));
            }
            return builder.toString();
        }
        return value.toString();
    }

    public static String toString(Object value) {
        return StringConverter.toStringWithDefault(value, "");
    }

    public static String toStringWithDefault(Object value, String defaultValue) {
        String result = StringConverter.toNullableString(value);
        return result != null ? result : defaultValue;
    }
}

