/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import org.pipservices4.commons.convert.IntegerConverter;
import org.pipservices4.commons.convert.StringConverter;

public class EnumConverter {
    public static <T extends Enum<T>> T toNullableEnum(Class<T> type, Object value) {
        Integer intValue = IntegerConverter.toNullableInteger(value);
        String strValue = StringConverter.toNullableString(value);
        if (intValue == null && strValue == null) {
            return null;
        }
        for (Enum e : (Enum[])type.getEnumConstants()) {
            if (intValue != null && e.ordinal() == intValue.intValue()) {
                return (T)e;
            }
            if (!e.name().equalsIgnoreCase(strValue)) continue;
            return (T)e;
        }
        return null;
    }

    public static <T extends Enum<T>> T toEnum(Class<T> type, Object value) {
        Enum[] elements = (Enum[])type.getEnumConstants();
        Enum defaultElement = elements != null && elements.length > 0 ? elements[0] : null;
        return (T)EnumConverter.toEnumWithDefault(type, value, defaultElement);
    }

    public static <T extends Enum<T>> T toEnumWithDefault(Class<T> type, Object value, T defaultValue) {
        T result = EnumConverter.toNullableEnum(type, value);
        return result != null ? result : defaultValue;
    }
}

