/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.tokenizers.generic;

import org.pipservices3.expressions.io.IScanner;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.IWordState;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.tokenizers.TokenType;
import org.pipservices3.expressions.tokenizers.utilities.CharReferenceMap;
import org.pipservices3.expressions.tokenizers.utilities.CharValidator;

public class GenericWordState
implements IWordState {
    private final CharReferenceMap<Boolean> _map = new CharReferenceMap();

    public GenericWordState() throws Exception {
        this.setWordChars(97, 122, true);
        this.setWordChars(65, 90, true);
        this.setWordChars(48, 57, true);
        this.setWordChars(45, 45, true);
        this.setWordChars(95, 95, true);
        this.setWordChars(192, 255, true);
        this.setWordChars(256, 65534, true);
    }

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int line = scanner.peekLine();
        int column = scanner.peekColumn();
        StringBuilder tokenValue = new StringBuilder();
        int nextSymbol = scanner.read();
        while (nextSymbol != -1 && this._map.lookup(nextSymbol) != null && this._map.lookup(nextSymbol).booleanValue()) {
            tokenValue.append((char)nextSymbol);
            nextSymbol = scanner.read();
        }
        if (!CharValidator.isEof(nextSymbol)) {
            scanner.unread();
        }
        return new Token(TokenType.Word, tokenValue.toString(), line, column);
    }

    @Override
    public void setWordChars(int fromSymbol, int toSymbol, boolean enable) throws Exception {
        this._map.addInterval(fromSymbol, toSymbol, enable);
    }

    @Override
    public void clearWordChars() {
        this._map.clear();
    }
}

