/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.mustache.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pipservices3.expressions.mustache.MustacheException;
import org.pipservices3.expressions.mustache.parsers.MustacheLexicalState;
import org.pipservices3.expressions.mustache.parsers.MustacheToken;
import org.pipservices3.expressions.mustache.parsers.MustacheTokenType;
import org.pipservices3.expressions.mustache.tokenizers.MustacheTokenizer;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.Token;

public class MustacheParser {
    private final ITokenizer _tokenizer = new MustacheTokenizer();
    private String _template = "";
    private List<Token> _originalTokens = new ArrayList<Token>();
    private List<MustacheToken> _initialTokens = new ArrayList<MustacheToken>();
    private int _currentTokenIndex;
    private List<String> _variableNames = new ArrayList<String>();
    private List<MustacheToken> _resultTokens = new ArrayList<MustacheToken>();

    public String getTemplate() {
        return this._template;
    }

    public void setTemplate(String value) throws Exception {
        this.parseString(value);
    }

    public List<Token> getOriginalTokens() {
        return this._originalTokens;
    }

    public void setOriginalTokens(List<Token> value) throws MustacheException {
        this.parseTokens(value);
    }

    public List<MustacheToken> getInitialTokens() {
        return this._initialTokens;
    }

    public List<MustacheToken> getResultTokens() {
        return this._resultTokens;
    }

    public List<String> getVariableNames() {
        return this._variableNames;
    }

    public void parseString(String mustache) throws Exception {
        this.clear();
        this._template = mustache != null ? mustache.trim() : "";
        this._originalTokens = this.tokenizeMustache(this._template);
        this.performParsing();
    }

    public void parseTokens(List<Token> tokens) throws MustacheException {
        this.clear();
        this._originalTokens = tokens;
        this._template = this.composeMustache(tokens);
        this.performParsing();
    }

    public void clear() {
        this._template = null;
        this._originalTokens = new ArrayList<Token>();
        this._initialTokens = new ArrayList<MustacheToken>();
        this._resultTokens = new ArrayList<MustacheToken>();
        this._currentTokenIndex = 0;
        this._variableNames = new ArrayList<String>();
    }

    private boolean hasMoreTokens() {
        return this._currentTokenIndex < this._initialTokens.size();
    }

    private void checkForMoreTokens() throws MustacheException {
        if (!this.hasMoreTokens()) {
            throw new MustacheException(null, "UNEXPECTED_END", "Unexpected end of mustache", 0, 0);
        }
    }

    private MustacheToken getCurrentToken() {
        return this._currentTokenIndex < this._initialTokens.size() ? this._initialTokens.get(this._currentTokenIndex) : null;
    }

    private MustacheToken getNextToken() {
        return this._currentTokenIndex + 1 < this._initialTokens.size() ? this._initialTokens.get(this._currentTokenIndex + 1) : null;
    }

    private void moveToNextToken() {
        ++this._currentTokenIndex;
    }

    private MustacheToken addTokenToResult(MustacheTokenType type, String value, int line, int column) {
        MustacheToken token = new MustacheToken(type, value, line, column);
        this._resultTokens.add(token);
        return token;
    }

    private List<Token> tokenizeMustache(String mustache) throws Exception {
        String string = mustache = mustache != null ? mustache.trim() : "";
        if (mustache.length() > 0) {
            this._tokenizer.setSkipWhitespaces(true);
            this._tokenizer.setSkipComments(true);
            this._tokenizer.setSkipEof(true);
            this._tokenizer.setDecodeStrings(true);
            return this._tokenizer.tokenizeBuffer(mustache);
        }
        return new ArrayList<Token>();
    }

    private String composeMustache(List<Token> tokens) {
        StringBuilder builder = new StringBuilder();
        for (Token token : tokens) {
            builder.append(token.getValue());
        }
        return builder.toString();
    }

    private void performParsing() throws MustacheException {
        if (this._originalTokens.size() > 0) {
            this.completeLexicalAnalysis();
            this.performSyntaxAnalysis();
            if (this.hasMoreTokens()) {
                MustacheToken token = this.getCurrentToken();
                throw new MustacheException(null, "ERROR_NEAR", "Syntax error near " + (token != null ? token.getValue() : "unknown"), token != null ? token.getLine() : 0, token != null ? token.getColumn() : 0);
            }
            this.lookupVariables();
        }
    }

    private void completeLexicalAnalysis() throws MustacheException {
        MustacheLexicalState state = MustacheLexicalState.Value;
        String closingBracket = null;
        String operator1 = null;
        String operator2 = null;
        String variable = null;
        block6: for (Token token : this._originalTokens) {
            MustacheTokenType tokenType = MustacheTokenType.Unknown;
            String tokenValue = null;
            if (state == MustacheLexicalState.Comment) {
                if (!Objects.equals(token.getValue(), "}}") && !Objects.equals(token.getValue(), "}}}")) continue;
                state = MustacheLexicalState.Closure;
            }
            switch (token.getType()) {
                case Special: {
                    if (state != MustacheLexicalState.Value) break;
                    tokenType = MustacheTokenType.Value;
                    tokenValue = token.getValue();
                    break;
                }
                case Symbol: {
                    if (state == MustacheLexicalState.Value && (Objects.equals(token.getValue(), "{{") || Objects.equals(token.getValue(), "{{{"))) {
                        closingBracket = Objects.equals(token.getValue(), "{{") ? "}}" : "}}}";
                        state = MustacheLexicalState.Operator1;
                        continue block6;
                    }
                    if (state == MustacheLexicalState.Operator1 && Objects.equals(token.getValue(), "!")) {
                        operator1 = token.getValue();
                        state = MustacheLexicalState.Comment;
                        continue block6;
                    }
                    if (state == MustacheLexicalState.Operator1 && (Objects.equals(token.getValue(), "/") || Objects.equals(token.getValue(), "#") || Objects.equals(token.getValue(), "^"))) {
                        operator1 = token.getValue();
                        state = MustacheLexicalState.Operator2;
                        continue block6;
                    }
                    if (state == MustacheLexicalState.Variable && (Objects.equals(token.getValue(), "}}") || Objects.equals(token.getValue(), "}}}"))) {
                        if (!Objects.equals(operator1, "/")) {
                            variable = operator2;
                            operator2 = null;
                        }
                        state = MustacheLexicalState.Closure;
                    }
                    if (state != MustacheLexicalState.Closure || !Objects.equals(token.getValue(), "}}") && !Objects.equals(token.getValue(), "}}}")) break;
                    if (!closingBracket.equals(token.getValue())) {
                        throw new MustacheException(null, "MISMATCHED_BRACKETS", "Mismatched brackets. Expected '" + closingBracket + "'", token.getLine(), token.getColumn());
                    }
                    if (Objects.equals(operator1, "#") && (operator2 == null || operator2.equals("if"))) {
                        tokenType = MustacheTokenType.Section;
                        tokenValue = variable;
                    }
                    if (Objects.equals(operator1, "#") && Objects.equals(operator2, "unless")) {
                        tokenType = MustacheTokenType.InvertedSection;
                        tokenValue = variable;
                    }
                    if (Objects.equals(operator1, "^") && operator2 == null) {
                        tokenType = MustacheTokenType.InvertedSection;
                        tokenValue = variable;
                    }
                    if (Objects.equals(operator1, "/")) {
                        tokenType = MustacheTokenType.SectionEnd;
                        tokenValue = variable;
                    }
                    if (operator1 == null) {
                        tokenType = closingBracket.equals("}}") ? MustacheTokenType.Variable : MustacheTokenType.EscapedVariable;
                        tokenValue = variable;
                    }
                    if (tokenType == MustacheTokenType.Unknown) {
                        throw new MustacheException(null, "INTERNAL", "Internal error", token.getLine(), token.getColumn());
                    }
                    operator1 = null;
                    operator2 = null;
                    variable = null;
                    state = MustacheLexicalState.Value;
                    break;
                }
                case Word: {
                    if (state == MustacheLexicalState.Operator1) {
                        state = MustacheLexicalState.Variable;
                    }
                    if (state == MustacheLexicalState.Operator2 && (Objects.equals(token.getValue(), "if") || Objects.equals(token.getValue(), "unless"))) {
                        operator2 = token.getValue();
                        state = MustacheLexicalState.Variable;
                        continue block6;
                    }
                    if (state == MustacheLexicalState.Operator2) {
                        state = MustacheLexicalState.Variable;
                    }
                    if (state != MustacheLexicalState.Variable) break;
                    variable = token.getValue();
                    state = MustacheLexicalState.Closure;
                    continue block6;
                }
                case Whitespace: {
                    continue block6;
                }
            }
            if (tokenType == MustacheTokenType.Unknown) {
                throw new MustacheException(null, "UNEXPECTED_SYMBOL", "Unexpected symbol '" + token.getValue() + "'", token.getLine(), token.getColumn());
            }
            this._initialTokens.add(new MustacheToken(tokenType, tokenValue, token.getLine(), token.getColumn()));
        }
        if (state != MustacheLexicalState.Value) {
            throw new MustacheException(null, "UNEXPECTED_END", "Unexpected end of file", 0, 0);
        }
    }

    private void performSyntaxAnalysis() throws MustacheException {
        this.checkForMoreTokens();
        while (this.hasMoreTokens()) {
            MustacheToken token = this.getCurrentToken();
            this.moveToNextToken();
            if (token == null || token.getType() == MustacheTokenType.SectionEnd) {
                throw new MustacheException(null, "UNEXPECTED_SECTION_END", "Unexpected section end for variable '" + (token != null ? token.getValue() : "unknown") + "'", token != null ? token.getLine() : 0, token != null ? token.getColumn() : 0);
            }
            MustacheToken result = this.addTokenToResult(token.getType(), token.getValue(), token.getLine(), token.getColumn());
            if (token.getType() != MustacheTokenType.Section && token.getType() != MustacheTokenType.InvertedSection) continue;
            result.getTokens().addAll(this.performSyntaxAnalysisForSection(token.getValue()));
        }
    }

    private List<MustacheToken> performSyntaxAnalysisForSection(String variable) throws MustacheException {
        MustacheToken token;
        ArrayList<MustacheToken> result = new ArrayList<MustacheToken>();
        this.checkForMoreTokens();
        while (this.hasMoreTokens()) {
            token = this.getCurrentToken();
            this.moveToNextToken();
            if (token == null) continue;
            if (token.getType() == MustacheTokenType.SectionEnd && (Objects.equals(token.getValue(), variable) || token.getValue() == null)) {
                return result;
            }
            if (token.getType() == MustacheTokenType.SectionEnd) {
                throw new MustacheException(null, "UNEXPECTED_SECTION_END", "Unexpected section end for variable '" + variable + "'", token.getLine(), token.getColumn());
            }
            MustacheToken resultToken = new MustacheToken(token.getType(), token.getValue(), token.getLine(), token.getColumn());
            if (token.getType() == MustacheTokenType.Section || token.getType() == MustacheTokenType.InvertedSection) {
                resultToken.getTokens().addAll(this.performSyntaxAnalysisForSection(token.getValue()));
            }
            result.add(resultToken);
        }
        token = this.getCurrentToken();
        throw new MustacheException(null, "NOT_CLOSED_SECTION", "Not closed section for variable '" + variable + "'", token != null ? token.getLine() : 0, token != null ? token.getColumn() : 0);
    }

    private void lookupVariables() {
        if (this._originalTokens == null) {
            return;
        }
        this._variableNames = new ArrayList<String>();
        for (MustacheToken token : this._initialTokens) {
            if (token.getType() == MustacheTokenType.Value || token.getType() == MustacheTokenType.Comment || token.getValue() == null) continue;
            String variableName = token.getValue().toLowerCase();
            boolean found = this._variableNames.stream().anyMatch(v -> v.toLowerCase().equals(variableName));
            if (found) continue;
            this._variableNames.add(token.getValue());
        }
    }
}

