/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.io;

import org.pipservices3.expressions.io.IScanner;

public class StringScanner
implements IScanner {
    public static final int EOF = -1;
    private final String _content;
    private int _position;
    private int _line;
    private int _column;

    public StringScanner(String content) {
        if (content == null) {
            throw new NullPointerException("Content cannot be null");
        }
        this._content = content;
        this._position = -1;
        this._line = 1;
        this._column = 0;
    }

    private int charAt(int position) {
        if (position < 0 || position >= this._content.length()) {
            return -1;
        }
        return this._content.codePointAt(position);
    }

    private boolean isLine(int charBefore, int charAt, int charAfter) {
        if (charAt != 10 && charAt != 13) {
            return false;
        }
        return charAt != 13 || charBefore != 10 && charAfter != 10;
    }

    private boolean isColumn(int charAt) {
        return charAt != 10 && charAt != 13;
    }

    @Override
    public int line() {
        return this._line;
    }

    @Override
    public int column() {
        return this._column;
    }

    @Override
    public int read() {
        int charAfter;
        int charAt;
        if (this._position + 1 > this._content.length()) {
            return -1;
        }
        ++this._position;
        if (this._position >= this._content.length()) {
            return -1;
        }
        int charBefore = this.charAt(this._position - 1);
        if (this.isLine(charBefore, charAt = this.charAt(this._position), charAfter = this.charAt(this._position + 1))) {
            ++this._line;
            this._column = 0;
        }
        if (this.isColumn(charAt)) {
            ++this._column;
        }
        return charAt;
    }

    @Override
    public int peek() {
        return this.charAt(this._position + 1);
    }

    @Override
    public int peekLine() {
        int charAfter;
        int charAt;
        int charBefore = this.charAt(this._position);
        return this.isLine(charBefore, charAt = this.charAt(this._position + 1), charAfter = this.charAt(this._position + 2)) ? this._line + 1 : this._line;
    }

    @Override
    public int peekColumn() {
        int charAfter;
        int charAt;
        int charBefore = this.charAt(this._position);
        if (this.isLine(charBefore, charAt = this.charAt(this._position + 1), charAfter = this.charAt(this._position + 2))) {
            return 0;
        }
        return this.isColumn(charAt) ? this._column + 1 : this._column;
    }

    @Override
    public void unread() {
        if (this._position < -1) {
            return;
        }
        --this._position;
        if (this._column > 0) {
            --this._column;
            return;
        }
        this._line = 1;
        this._column = 0;
        int charBefore = -1;
        int charAt = -1;
        int charAfter = this.charAt(0);
        for (int position = 0; position <= this._position; ++position) {
            charBefore = charAt;
            if (this.isLine(charBefore, charAt = charAfter, charAfter = this.charAt(position + 1))) {
                ++this._line;
                this._column = 0;
            }
            if (!this.isColumn(charAt)) continue;
            ++this._column;
        }
    }

    @Override
    public void unreadMany(int count) {
        while (count > 0) {
            this.unread();
            --count;
        }
    }

    @Override
    public void reset() {
        this._position = -1;
        this._line = 1;
        this._column = 0;
    }
}

