/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.variants;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.pipservices3.commons.convert.StringConverter;
import org.pipservices3.expressions.variants.VariantType;

public class Variant {
    private VariantType _type;
    private Object _value;
    public static final Variant Empty = new Variant();

    public Variant(Object value) {
        this.setAsObject(value);
    }

    public Variant() {
    }

    public VariantType getType() {
        return this._type;
    }

    public Integer getAsInteger() {
        return (Integer)this._value;
    }

    public void setAsInteger(Integer value) {
        this._type = VariantType.Integer;
        this._value = value;
    }

    public Long getAsLong() {
        return (Long)this._value;
    }

    public void setAsLong(Long value) {
        this._type = VariantType.Long;
        this._value = value;
    }

    public Boolean getAsBoolean() {
        return (Boolean)this._value;
    }

    public void setAsBoolean(Boolean value) {
        this._type = VariantType.Boolean;
        this._value = value;
    }

    public Float getAsFloat() {
        return (Float)this._value;
    }

    public void setAsFloat(Float value) {
        this._type = VariantType.Float;
        this._value = value;
    }

    public Double getAsDouble() {
        return (Double)this._value;
    }

    public void setAsDouble(Double value) {
        this._type = VariantType.Double;
        this._value = value;
    }

    public String getAsString() {
        return (String)this._value;
    }

    public void setAsString(String value) {
        this._type = VariantType.String;
        this._value = value;
    }

    public ZonedDateTime getAsDateTime() {
        return (ZonedDateTime)this._value;
    }

    public void setAsDateTime(ZonedDateTime value) {
        this._type = VariantType.DateTime;
        this._value = value;
    }

    public Long getAsTimeSpan() {
        return (Long)this._value;
    }

    public void setAsTimeSpan(Long value) {
        this._type = VariantType.TimeSpan;
        this._value = value;
    }

    public Object getAsObject() {
        return this._value;
    }

    public void setAsObject(Object value) {
        this._value = value;
        if (value == null) {
            this._type = VariantType.Null;
        } else if (value instanceof Integer) {
            this._type = VariantType.Integer;
        } else if (value instanceof Long) {
            this._type = VariantType.Long;
        } else if (value instanceof Double) {
            this._type = VariantType.Double;
        } else if (value instanceof Boolean) {
            this._type = VariantType.Boolean;
        } else if (value instanceof ZonedDateTime) {
            this._type = VariantType.DateTime;
        } else if (value instanceof String) {
            this._type = VariantType.String;
        } else if (value instanceof List) {
            this._type = VariantType.Array;
        } else if (value instanceof Variant) {
            this._type = ((Variant)value)._type;
            this._value = ((Variant)value)._value;
        } else {
            this._type = VariantType.Object;
        }
    }

    public List<Variant> getAsArray() {
        return (List)this._value;
    }

    public void setAsArray(List<Variant> value) {
        this._type = VariantType.Array;
        this._value = value != null ? new ArrayList<Variant>(value) : null;
    }

    public Integer getLength() {
        if (this._type == VariantType.Array) {
            return this._value instanceof List ? ((List)this._value).size() : 0;
        }
        return 0;
    }

    public void setLength(int value) throws Exception {
        if (this._type == VariantType.Array) {
            while (((List)this._value).size() < value) {
                ((List)this._value).add(null);
            }
        } else {
            throw new Exception("Cannot set array length for non-array data type.");
        }
    }

    public Variant getByIndex(int index) throws Exception {
        if (this._type == VariantType.Array) {
            if (this._value instanceof List && ((List)this._value).size() > index) {
                return (Variant)((List)this._value).get(index);
            }
            throw new Exception("Requested element of array is not accessible.");
        }
        throw new Exception("Cannot access array element for none-array data type.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setByIndex(int index, Variant element) throws Exception {
        if (this._type != VariantType.Array) throw new Exception("Cannot access array element for none-array data type.");
        if (!(this._value instanceof List)) throw new Exception("Requested element of array is not accessible.");
        while (((List)this._value).size() <= index) {
            ((List)this._value).add(null);
        }
        ((List)this._value).set(index, element);
    }

    public boolean isNull() {
        return this._type == VariantType.Null;
    }

    public boolean isEmpty() {
        return this._value == null;
    }

    public void assign(Variant value) {
        if (value != null) {
            this._type = value._type;
            this._value = value._value;
        } else {
            this._type = VariantType.Null;
            this._value = null;
        }
    }

    public void clear() {
        this._type = VariantType.Null;
        this._value = null;
    }

    public String toString() {
        return this._value == null ? "null" : StringConverter.toString((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variant) {
            Variant varObj = (Variant)obj;
            Object value1 = this._value;
            Object value2 = varObj._value;
            if (value1 == null || value2 == null) {
                return value1 == value2;
            }
            return this._type == varObj._type && value1 == value2;
        }
        return false;
    }

    public Variant clone() {
        return new Variant(this);
    }

    public static Variant fromInteger(Integer value) {
        Variant result = new Variant();
        result.setAsInteger(value);
        return result;
    }

    public static Variant fromLong(Long value) {
        Variant result = new Variant();
        result.setAsLong(value);
        return result;
    }

    public static Variant fromBoolean(boolean value) {
        Variant result = new Variant();
        result.setAsBoolean(value);
        return result;
    }

    public static Variant fromFloat(Float value) {
        Variant result = new Variant();
        result.setAsFloat(value);
        return result;
    }

    public static Variant fromDouble(Double value) {
        Variant result = new Variant();
        result.setAsDouble(value);
        return result;
    }

    public static Variant fromString(String value) {
        Variant result = new Variant();
        result.setAsString(value);
        return result;
    }

    public static Variant fromDateTime(ZonedDateTime value) {
        Variant result = new Variant();
        result.setAsDateTime(value);
        return result;
    }

    public static Variant fromTimeSpan(Long value) {
        Variant result = new Variant();
        result.setAsTimeSpan(value);
        return result;
    }

    public static Variant fromObject(Object value) {
        Variant result = new Variant();
        result.setAsObject(value);
        return result;
    }

    public static Variant fromArray(List<Variant> value) {
        Variant result = new Variant();
        result.setAsArray(value);
        return result;
    }
}

