/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.tokenizers.generic;

import org.pipservices3.expressions.io.IScanner;
import org.pipservices3.expressions.tokenizers.TokenType;
import org.pipservices3.expressions.tokenizers.utilities.CharReferenceMap;
import org.pipservices3.expressions.tokenizers.utilities.CharValidator;

public class SymbolNode {
    private final SymbolNode _parent;
    private final int _character;
    private CharReferenceMap<SymbolNode> _children;
    private TokenType _tokenType = TokenType.Unknown;
    private boolean _valid;
    private String _ancestry;

    public SymbolNode(SymbolNode parent, int character) {
        this._parent = parent;
        this._character = character;
    }

    public SymbolNode ensureChildWithChar(int value) throws Exception {
        SymbolNode childNode;
        if (this._children == null) {
            this._children = new CharReferenceMap();
        }
        if ((childNode = this._children.lookup(value)) == null) {
            childNode = new SymbolNode(this, value);
            this._children.addInterval(value, value, childNode);
        }
        return childNode;
    }

    public void addDescendantLine(String value, TokenType tokenType) throws Exception {
        if (value.length() > 0) {
            SymbolNode childNode = this.ensureChildWithChar(value.codePointAt(0));
            childNode.addDescendantLine(value.substring(1), tokenType);
        } else {
            this._valid = true;
            this._tokenType = tokenType;
        }
    }

    public SymbolNode deepestRead(IScanner scanner) {
        SymbolNode childNode;
        int nextSymbol = scanner.read();
        SymbolNode symbolNode = childNode = !CharValidator.isEof(nextSymbol) ? this.findChildWithChar(nextSymbol) : null;
        if (childNode == null) {
            scanner.unread();
            return this;
        }
        return childNode.deepestRead(scanner);
    }

    public SymbolNode findChildWithChar(int value) {
        return this._children != null ? this._children.lookup(value) : null;
    }

    public SymbolNode unreadToValid(IScanner scanner) {
        if (!this._valid && this._parent != null) {
            scanner.unread();
            return this._parent.unreadToValid(scanner);
        }
        return this;
    }

    public boolean getValid() {
        return this._valid;
    }

    public void setValid(boolean value) {
        this._valid = value;
    }

    public TokenType getTokenType() {
        return this._tokenType;
    }

    public void setTokenType(TokenType value) {
        this._tokenType = value;
    }

    public String ancestry() {
        if (this._ancestry == null) {
            this._ancestry = (this._parent != null ? this._parent.ancestry() : "") + (this._character != 0 ? String.valueOf((char)this._character) : "");
        }
        return this._ancestry;
    }
}

