/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.tokenizers.generic;

import org.pipservices3.expressions.io.IScanner;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.IWhitespaceState;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.tokenizers.TokenType;
import org.pipservices3.expressions.tokenizers.utilities.CharReferenceMap;
import org.pipservices3.expressions.tokenizers.utilities.CharValidator;

public class GenericWhitespaceState
implements IWhitespaceState {
    private final CharReferenceMap<Boolean> _map = new CharReferenceMap();

    public GenericWhitespaceState() throws Exception {
        this.setWhitespaceChars(0, 32, true);
    }

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int line = scanner.peekLine();
        int column = scanner.peekColumn();
        StringBuilder tokenValue = new StringBuilder();
        int nextSymbol = scanner.read();
        while (nextSymbol != -1 && this._map.lookup(nextSymbol) != null && this._map.lookup(nextSymbol).booleanValue()) {
            tokenValue.append((char)nextSymbol);
            nextSymbol = scanner.read();
        }
        if (!CharValidator.isEof(nextSymbol)) {
            scanner.unread();
        }
        return new Token(TokenType.Whitespace, tokenValue.toString(), line, column);
    }

    @Override
    public void setWhitespaceChars(int fromSymbol, int toSymbol, boolean enable) throws Exception {
        this._map.addInterval(fromSymbol, toSymbol, enable);
    }

    @Override
    public void clearWhitespaceChars() {
        this._map.clear();
    }
}

