/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.tokenizers.generic;

import org.pipservices3.expressions.io.IScanner;
import org.pipservices3.expressions.tokenizers.IQuoteState;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.tokenizers.TokenType;
import org.pipservices3.expressions.tokenizers.utilities.CharValidator;

public class GenericQuoteState
implements IQuoteState {
    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) {
        int firstSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        StringBuilder tokenValue = new StringBuilder(String.valueOf((char)firstSymbol));
        int nextSymbol = scanner.read();
        while (!CharValidator.isEof(nextSymbol)) {
            tokenValue.append((char)nextSymbol);
            if (nextSymbol == firstSymbol) break;
            nextSymbol = scanner.read();
        }
        return new Token(TokenType.Quoted, tokenValue.toString(), line, column);
    }

    @Override
    public String encodeString(String value, int quoteSymbol) {
        if (value == null) {
            return null;
        }
        return (char)quoteSymbol + value + (char)quoteSymbol;
    }

    @Override
    public String decodeString(String value, int quoteSymbol) {
        if (value == null) {
            return null;
        }
        if (value.length() >= 2 && value.codePointAt(0) == quoteSymbol && value.codePointAt(value.length() - 1) == quoteSymbol) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

