/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.csv;

import java.security.InvalidParameterException;
import java.util.List;
import org.pipservices3.expressions.csv.CsvQuoteState;
import org.pipservices3.expressions.csv.CsvSymbolState;
import org.pipservices3.expressions.csv.CsvWordState;
import org.pipservices3.expressions.tokenizers.AbstractTokenizer;

public class CsvTokenizer
extends AbstractTokenizer {
    private List<Integer> _fieldSeparators = List.of(Integer.valueOf(",".codePointAt(0)));
    private List<Integer> _quoteSymbols = List.of(Integer.valueOf("\"".codePointAt(0)));
    private String _endOfLine = "\n\r";

    public CsvTokenizer() throws Exception {
        this.setNumberState(null);
        this.setWhitespaceState(null);
        this.setCommentState(null);
        this.setWordState(new CsvWordState(this.getFieldSeparators(), this.getQuoteSymbols()));
        this.setSymbolState(new CsvSymbolState());
        this.setQuoteState(new CsvQuoteState());
        this.assignStates();
    }

    public List<Integer> getFieldSeparators() {
        return this._fieldSeparators;
    }

    public void setFieldSeparators(List<Integer> value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        for (Integer fieldSeparator : value) {
            if (fieldSeparator == 13 || fieldSeparator == 10 || fieldSeparator == 0) {
                throw new InvalidParameterException("Invalid field separator.");
            }
            for (Integer quoteSymbol : this.getQuoteSymbols()) {
                if (!fieldSeparator.equals(quoteSymbol)) continue;
                throw new InvalidParameterException("Invalid field separator.");
            }
        }
        this._fieldSeparators = value;
        this.setWordState(new CsvWordState(value, this.getQuoteSymbols()));
        this.assignStates();
    }

    public String getEndOfLine() {
        return this._endOfLine;
    }

    public void setEndOfLine(String value) {
        this._endOfLine = value;
    }

    public List<Integer> getQuoteSymbols() {
        return this._quoteSymbols;
    }

    public void setQuoteSymbols(List<Integer> value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        for (Integer quoteSymbol : value) {
            if (quoteSymbol == 13 || quoteSymbol == 10 || quoteSymbol == 0) {
                throw new InvalidParameterException("Invalid quote symbol.");
            }
            for (Integer fieldSeparator : this.getFieldSeparators()) {
                if (!quoteSymbol.equals(fieldSeparator)) continue;
                throw new InvalidParameterException("Invalid quote symbol.");
            }
        }
        this._quoteSymbols = value;
        this.setWordState(new CsvWordState(this.getFieldSeparators(), value));
        this.assignStates();
    }

    private void assignStates() throws Exception {
        this.clearCharacterStates();
        this.setCharacterState(0, 65534, this.getWordState());
        this.setCharacterState(13, 13, this.getSymbolState());
        this.setCharacterState(10, 10, this.getSymbolState());
        for (Integer fieldSeparator : this.getFieldSeparators()) {
            this.setCharacterState(fieldSeparator, fieldSeparator, this.getSymbolState());
        }
        for (Integer quoteSymbol : this.getQuoteSymbols()) {
            this.setCharacterState(quoteSymbol, quoteSymbol, this.getQuoteState());
        }
    }
}

