/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.calculator.variables;

import java.util.ArrayList;
import java.util.List;
import org.pipservices3.expressions.calculator.variables.IVariable;
import org.pipservices3.expressions.calculator.variables.IVariableCollection;
import org.pipservices3.expressions.calculator.variables.Variable;
import org.pipservices3.expressions.variants.Variant;

public class VariableCollection
implements IVariableCollection {
    private List<IVariable> _variables = new ArrayList<IVariable>();

    @Override
    public void add(IVariable variable) {
        if (variable == null) {
            throw new NullPointerException("Variable cannot be null");
        }
        this._variables.add(variable);
    }

    @Override
    public int length() {
        return this._variables.size();
    }

    @Override
    public IVariable get(int index) {
        return this._variables.get(index);
    }

    @Override
    public List<IVariable> getAll() {
        ArrayList<IVariable> result = new ArrayList<IVariable>();
        for (IVariable variable : this._variables) {
            result.add(new Variable(variable.getName(), variable.getValue()));
        }
        return result;
    }

    @Override
    public int findIndexByName(String name) {
        name = name.toUpperCase();
        for (int i = 0; i < this._variables.size(); ++i) {
            String varName = this._variables.get(i).getName().toUpperCase();
            if (!varName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IVariable findByName(String name) {
        int index = this.findIndexByName(name);
        return index >= 0 ? this._variables.get(index) : null;
    }

    @Override
    public IVariable locate(String name) {
        IVariable v = this.findByName(name);
        if (v == null) {
            v = new Variable(name);
            this.add(v);
        }
        return v;
    }

    @Override
    public void remove(int index) {
        this._variables.remove(index);
    }

    @Override
    public void removeByName(String name) {
        int index = this.findIndexByName(name);
        if (index >= 0) {
            this.remove(index);
        }
    }

    @Override
    public void clear() {
        this._variables = new ArrayList<IVariable>();
    }

    @Override
    public void clearValues() {
        for (IVariable v : this._variables) {
            v.setValue(new Variant());
        }
    }
}

