/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.calculator.tokenizers;

import java.util.Objects;
import org.pipservices3.expressions.io.IScanner;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.tokenizers.TokenType;
import org.pipservices3.expressions.tokenizers.generic.GenericWordState;

public class ExpressionWordState
extends GenericWordState {
    public final String[] keywords = new String[]{"AND", "OR", "NOT", "XOR", "LIKE", "IS", "IN", "NULL", "TRUE", "FALSE"};

    public ExpressionWordState() throws Exception {
        this.clearWordChars();
        this.setWordChars(97, 122, true);
        this.setWordChars(65, 90, true);
        this.setWordChars(48, 57, true);
        this.setWordChars(95, 95, true);
        this.setWordChars(192, 255, true);
        this.setWordChars(256, 65534, true);
    }

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int line = scanner.peekLine();
        int column = scanner.peekColumn();
        Token token = super.nextToken(scanner, tokenizer);
        String value = token.getValue().toUpperCase();
        for (String keyword : this.keywords) {
            if (!Objects.equals(keyword, value)) continue;
            return new Token(TokenType.Keyword, token.getValue(), line, column);
        }
        return token;
    }
}

