/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.calculator.parsers;

import java.util.ArrayList;
import java.util.List;
import org.pipservices3.commons.convert.FloatConverter;
import org.pipservices3.commons.convert.IntegerConverter;
import org.pipservices3.expressions.calculator.SyntaxException;
import org.pipservices3.expressions.calculator.parsers.ExpressionToken;
import org.pipservices3.expressions.calculator.parsers.ExpressionTokenType;
import org.pipservices3.expressions.calculator.tokenizers.ExpressionTokenizer;
import org.pipservices3.expressions.tokenizers.ITokenizer;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.variants.Variant;

public class ExpressionParser {
    private final String[] Operators = new String[]{"(", ")", "[", "]", "+", "-", "*", "/", "%", "^", "=", "<>", "!=", ">", "<", ">=", "<=", "<<", ">>", "AND", "OR", "XOR", "NOT", "IS", "IN", "NULL", "LIKE", ","};
    private final ExpressionTokenType[] OperatorTypes = new ExpressionTokenType[]{ExpressionTokenType.LeftBrace, ExpressionTokenType.RightBrace, ExpressionTokenType.LeftSquareBrace, ExpressionTokenType.RightSquareBrace, ExpressionTokenType.Plus, ExpressionTokenType.Minus, ExpressionTokenType.Star, ExpressionTokenType.Slash, ExpressionTokenType.Procent, ExpressionTokenType.Power, ExpressionTokenType.Equal, ExpressionTokenType.NotEqual, ExpressionTokenType.NotEqual, ExpressionTokenType.More, ExpressionTokenType.Less, ExpressionTokenType.EqualMore, ExpressionTokenType.EqualLess, ExpressionTokenType.ShiftLeft, ExpressionTokenType.ShiftRight, ExpressionTokenType.And, ExpressionTokenType.Or, ExpressionTokenType.Xor, ExpressionTokenType.Not, ExpressionTokenType.Is, ExpressionTokenType.In, ExpressionTokenType.Null, ExpressionTokenType.Like, ExpressionTokenType.Comma};
    private final ITokenizer _tokenizer = new ExpressionTokenizer();
    private String _expression = "";
    private List<Token> _originalTokens = new ArrayList<Token>();
    private List<ExpressionToken> _initialTokens = new ArrayList<ExpressionToken>();
    private int _currentTokenIndex;
    private List<String> _variableNames = new ArrayList<String>();
    private List<ExpressionToken> _resultTokens = new ArrayList<ExpressionToken>();

    public String getExpression() {
        return this._expression;
    }

    public void setExpression(String value) throws Exception {
        this.parseString(value);
    }

    public List<Token> getOriginalTokens() {
        return this._originalTokens;
    }

    public void setOriginalTokens(List<Token> value) throws SyntaxException {
        this.parseTokens(value);
    }

    public List<ExpressionToken> getInitialTokens() {
        return this._initialTokens;
    }

    public List<ExpressionToken> getResultTokens() {
        return this._resultTokens;
    }

    public List<String> getVariableNames() {
        return this._variableNames;
    }

    public void parseString(String expression) throws Exception {
        this.clear();
        this._expression = expression != null ? expression.trim() : "";
        this._originalTokens = this.tokenizeExpression(this._expression);
        this.performParsing();
    }

    public void parseTokens(List<Token> tokens) throws SyntaxException {
        this.clear();
        this._originalTokens = tokens;
        this._expression = this.composeExpression(tokens);
        this.performParsing();
    }

    public void clear() {
        this._expression = null;
        this._originalTokens = new ArrayList<Token>();
        this._initialTokens = new ArrayList<ExpressionToken>();
        this._resultTokens = new ArrayList<ExpressionToken>();
        this._currentTokenIndex = 0;
        this._variableNames = new ArrayList<String>();
    }

    private boolean hasMoreTokens() {
        return this._currentTokenIndex < this._initialTokens.size();
    }

    private void checkForMoreTokens() throws SyntaxException {
        if (!this.hasMoreTokens()) {
            throw new SyntaxException(null, "UNEXPECTED_END", "Unexpected end of expression.", 0, 0);
        }
    }

    private ExpressionToken getCurrentToken() {
        return this._currentTokenIndex < this._initialTokens.size() ? this._initialTokens.get(this._currentTokenIndex) : null;
    }

    private ExpressionToken getNextToken() {
        return this._currentTokenIndex + 1 < this._initialTokens.size() ? this._initialTokens.get(this._currentTokenIndex + 1) : null;
    }

    private void moveToNextToken() {
        ++this._currentTokenIndex;
    }

    private void addTokenToResult(ExpressionTokenType type, Variant value, int line, int column) {
        this._resultTokens.add(new ExpressionToken(type, value, line, column));
    }

    private boolean matchTokensWithTypes(ExpressionTokenType ... types) {
        boolean matches = false;
        for (int i = 0; i < types.length; ++i) {
            if (this._currentTokenIndex + i >= this._initialTokens.size()) {
                matches = false;
                break;
            }
            matches = this._initialTokens.get(this._currentTokenIndex + i).getType() == types[i];
        }
        if (matches) {
            this._currentTokenIndex += types.length;
        }
        return matches;
    }

    private List<Token> tokenizeExpression(String expression) throws Exception {
        String string = expression = expression != null ? expression.trim() : "";
        if (expression.length() > 0) {
            this._tokenizer.setSkipWhitespaces(true);
            this._tokenizer.setSkipComments(true);
            this._tokenizer.setSkipEof(true);
            this._tokenizer.setDecodeStrings(true);
            return this._tokenizer.tokenizeBuffer(expression);
        }
        return new ArrayList<Token>();
    }

    private String composeExpression(List<Token> tokens) {
        StringBuilder builder = new StringBuilder();
        for (Token token : tokens) {
            builder.append(token.getValue());
        }
        return builder.toString();
    }

    private void performParsing() throws SyntaxException {
        if (this._originalTokens.size() > 0) {
            this.completeLexicalAnalysis();
            this.performSyntaxAnalysis();
            if (this.hasMoreTokens()) {
                ExpressionToken token = this.getCurrentToken();
                throw new SyntaxException(null, "ERROR_NEAR", String.valueOf(token != null ? token.getValue() : "unknown"), token != null ? token.getLine() : 0, token != null ? token.getColumn() : 0);
            }
        }
    }

    private void completeLexicalAnalysis() throws SyntaxException {
        block9: for (Token token : this._originalTokens) {
            ExpressionTokenType tokenType = ExpressionTokenType.Unknown;
            Variant tokenValue = Variant.Empty;
            block0 : switch (token.getType()) {
                case Comment: 
                case Whitespace: {
                    continue block9;
                }
                case Keyword: {
                    String temp = token.getValue().toUpperCase();
                    if (temp.equals("TRUE")) {
                        tokenType = ExpressionTokenType.Constant;
                        tokenValue = Variant.fromBoolean(true);
                        break;
                    }
                    if (temp.equals("FALSE")) {
                        tokenType = ExpressionTokenType.Constant;
                        tokenValue = Variant.fromBoolean(false);
                        break;
                    }
                    for (int index = 0; index < this.Operators.length; ++index) {
                        if (!temp.equals(this.Operators[index])) continue;
                        tokenType = this.OperatorTypes[index];
                        break block0;
                    }
                    break;
                }
                case Word: {
                    tokenType = ExpressionTokenType.Variable;
                    tokenValue = Variant.fromString(token.getValue());
                    break;
                }
                case Integer: {
                    tokenType = ExpressionTokenType.Constant;
                    tokenValue = Variant.fromInteger(IntegerConverter.toInteger((Object)token.getValue()));
                    break;
                }
                case Float: {
                    tokenType = ExpressionTokenType.Constant;
                    tokenValue = Variant.fromFloat(Float.valueOf(FloatConverter.toFloat((Object)token.getValue())));
                    break;
                }
                case Quoted: {
                    tokenType = ExpressionTokenType.Constant;
                    tokenValue = Variant.fromString(token.getValue());
                    break;
                }
                case Symbol: {
                    String temp = token.getValue().toUpperCase();
                    for (int i = 0; i < this.Operators.length; ++i) {
                        if (!temp.equals(this.Operators[i])) continue;
                        tokenType = this.OperatorTypes[i];
                        break block0;
                    }
                    break;
                }
            }
            if (tokenType == ExpressionTokenType.Unknown) {
                throw new SyntaxException(null, "UNKNOWN_SYMBOL", "Unknown symbol " + token.getValue(), token.getLine(), token.getColumn());
            }
            this._initialTokens.add(new ExpressionToken(tokenType, tokenValue, token.getLine(), token.getColumn()));
        }
    }

    private void performSyntaxAnalysis() throws SyntaxException {
        ExpressionToken token;
        this.checkForMoreTokens();
        this.performSyntaxAnalysisAtLevel1();
        while (this.hasMoreTokens() && (token = this.getCurrentToken()) != null && (token.getType() == ExpressionTokenType.And || token.getType() == ExpressionTokenType.Or || token.getType() == ExpressionTokenType.Xor)) {
            this.moveToNextToken();
            this.performSyntaxAnalysisAtLevel1();
            this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
        }
    }

    private void performSyntaxAnalysisAtLevel1() throws SyntaxException {
        this.checkForMoreTokens();
        ExpressionToken token = this.getCurrentToken();
        if (token != null && token.getType() == ExpressionTokenType.Not) {
            this.moveToNextToken();
            this.performSyntaxAnalysisAtLevel2();
            this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
        } else {
            this.performSyntaxAnalysisAtLevel2();
        }
    }

    private void performSyntaxAnalysisAtLevel2() throws SyntaxException {
        ExpressionToken token;
        this.checkForMoreTokens();
        this.performSyntaxAnalysisAtLevel3();
        while (this.hasMoreTokens() && (token = this.getCurrentToken()) != null && (token.getType() == ExpressionTokenType.Equal || token.getType() == ExpressionTokenType.NotEqual || token.getType() == ExpressionTokenType.More || token.getType() == ExpressionTokenType.Less || token.getType() == ExpressionTokenType.EqualMore || token.getType() == ExpressionTokenType.EqualLess)) {
            this.moveToNextToken();
            this.performSyntaxAnalysisAtLevel3();
            this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
        }
    }

    private void performSyntaxAnalysisAtLevel3() throws SyntaxException {
        ExpressionToken token;
        this.checkForMoreTokens();
        this.performSyntaxAnalysisAtLevel4();
        while (this.hasMoreTokens() && (token = this.getCurrentToken()) != null) {
            if (token.getType() == ExpressionTokenType.Plus || token.getType() == ExpressionTokenType.Minus || token.getType() == ExpressionTokenType.Like) {
                this.moveToNextToken();
                this.performSyntaxAnalysisAtLevel4();
                this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
                continue;
            }
            if (this.matchTokensWithTypes(ExpressionTokenType.Not, ExpressionTokenType.Like)) {
                this.performSyntaxAnalysisAtLevel4();
                this.addTokenToResult(ExpressionTokenType.NotLike, Variant.Empty, token.getLine(), token.getColumn());
                continue;
            }
            if (this.matchTokensWithTypes(ExpressionTokenType.Is, ExpressionTokenType.Null)) {
                this.addTokenToResult(ExpressionTokenType.IsNull, Variant.Empty, token.getLine(), token.getColumn());
                continue;
            }
            if (this.matchTokensWithTypes(ExpressionTokenType.Is, ExpressionTokenType.Not, ExpressionTokenType.Null)) {
                this.addTokenToResult(ExpressionTokenType.IsNotNull, Variant.Empty, token.getLine(), token.getColumn());
                continue;
            }
            if (!this.matchTokensWithTypes(ExpressionTokenType.Not, ExpressionTokenType.In)) break;
            this.performSyntaxAnalysisAtLevel4();
            this.addTokenToResult(ExpressionTokenType.NotIn, Variant.Empty, token.getLine(), token.getColumn());
        }
    }

    private void performSyntaxAnalysisAtLevel4() throws SyntaxException {
        ExpressionToken token;
        this.checkForMoreTokens();
        this.performSyntaxAnalysisAtLevel5();
        while (this.hasMoreTokens() && (token = this.getCurrentToken()) != null && (token.getType() == ExpressionTokenType.Star || token.getType() == ExpressionTokenType.Slash || token.getType() == ExpressionTokenType.Procent)) {
            this.moveToNextToken();
            this.performSyntaxAnalysisAtLevel5();
            this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
        }
    }

    private void performSyntaxAnalysisAtLevel5() throws SyntaxException {
        ExpressionToken token;
        this.checkForMoreTokens();
        this.performSyntaxAnalysisAtLevel6();
        while (this.hasMoreTokens() && (token = this.getCurrentToken()) != null && (token.getType() == ExpressionTokenType.Power || token.getType() == ExpressionTokenType.In || token.getType() == ExpressionTokenType.ShiftLeft || token.getType() == ExpressionTokenType.ShiftRight)) {
            this.moveToNextToken();
            this.performSyntaxAnalysisAtLevel6();
            this.addTokenToResult(token.getType(), Variant.Empty, token.getLine(), token.getColumn());
        }
    }

    private void performSyntaxAnalysisAtLevel6() throws SyntaxException {
        this.checkForMoreTokens();
        ExpressionToken unaryToken = this.getCurrentToken();
        if (unaryToken != null && unaryToken.getType() == ExpressionTokenType.Plus) {
            unaryToken = null;
            this.moveToNextToken();
        } else if (unaryToken != null && unaryToken.getType() == ExpressionTokenType.Minus) {
            unaryToken = new ExpressionToken(ExpressionTokenType.Unary, unaryToken.getValue(), unaryToken.getLine(), unaryToken.getColumn());
            this.moveToNextToken();
        } else {
            unaryToken = null;
        }
        this.checkForMoreTokens();
        ExpressionToken primitiveToken = this.getCurrentToken();
        ExpressionToken nextToken = this.getNextToken();
        if (primitiveToken.getType() == ExpressionTokenType.Variable && nextToken != null && nextToken.getType() == ExpressionTokenType.LeftBrace) {
            primitiveToken = new ExpressionToken(ExpressionTokenType.Function, primitiveToken.getValue(), primitiveToken.getLine(), primitiveToken.getColumn());
        }
        if (primitiveToken.getType() == ExpressionTokenType.Constant) {
            this.moveToNextToken();
            this.addTokenToResult(primitiveToken.getType(), primitiveToken.getValue(), primitiveToken.getLine(), primitiveToken.getColumn());
        } else if (primitiveToken.getType() == ExpressionTokenType.Variable) {
            this.moveToNextToken();
            String temp = primitiveToken.getValue().getAsString();
            if (!this._variableNames.contains(temp)) {
                this._variableNames.add(temp);
            }
            this.addTokenToResult(primitiveToken.getType(), primitiveToken.getValue(), primitiveToken.getLine(), primitiveToken.getColumn());
        } else if (primitiveToken.getType() == ExpressionTokenType.LeftBrace) {
            this.moveToNextToken();
            this.performSyntaxAnalysis();
            this.checkForMoreTokens();
            primitiveToken = this.getCurrentToken();
            if (primitiveToken.getType() != ExpressionTokenType.RightBrace) {
                throw new SyntaxException(null, "MISSED_CLOSE_PARENTHESIS", "Expected ')' was not found", primitiveToken.getLine(), primitiveToken.getColumn());
            }
            this.moveToNextToken();
        } else if (primitiveToken.getType() == ExpressionTokenType.Function) {
            this.moveToNextToken();
            ExpressionToken token = this.getCurrentToken();
            if (token.getType() != ExpressionTokenType.LeftBrace) {
                throw new SyntaxException(null, "INTERNAL", "Internal error", token.getLine(), token.getColumn());
            }
            int paramCount = 0;
            do {
                this.moveToNextToken();
                token = this.getCurrentToken();
                if (token == null || token.getType() == ExpressionTokenType.RightBrace) break;
                ++paramCount;
                this.performSyntaxAnalysis();
            } while ((token = this.getCurrentToken()) != null && token.getType() == ExpressionTokenType.Comma);
            this.checkForMoreTokens();
            if (token != null && token.getType() != ExpressionTokenType.RightBrace) {
                throw new SyntaxException(null, "MISSED_CLOSE_PARENTHESIS", "Expected ')' was not found", token.getLine(), token.getColumn());
            }
            this.moveToNextToken();
            this.addTokenToResult(ExpressionTokenType.Constant, new Variant(paramCount), primitiveToken.getLine(), primitiveToken.getColumn());
            this.addTokenToResult(primitiveToken.getType(), primitiveToken.getValue(), primitiveToken.getLine(), primitiveToken.getColumn());
        } else {
            throw new SyntaxException(null, "ERROR_AT", "Syntax error at " + primitiveToken.getValue(), primitiveToken.getLine(), primitiveToken.getColumn());
        }
        if (unaryToken != null) {
            this.addTokenToResult(unaryToken.getType(), Variant.Empty, unaryToken.getLine(), unaryToken.getColumn());
        }
        if (this.hasMoreTokens() && (primitiveToken = this.getCurrentToken()).getType() == ExpressionTokenType.LeftSquareBrace) {
            this.moveToNextToken();
            this.performSyntaxAnalysis();
            this.checkForMoreTokens();
            primitiveToken = this.getCurrentToken();
            if (primitiveToken.getType() != ExpressionTokenType.RightSquareBrace) {
                throw new SyntaxException(null, "MISSED_CLOSE_SQUARE_BRACKET", "Expected ']' was not found", primitiveToken.getLine(), primitiveToken.getColumn());
            }
            this.moveToNextToken();
            this.addTokenToResult(ExpressionTokenType.Element, Variant.Empty, primitiveToken.getLine(), primitiveToken.getColumn());
        }
    }
}

