/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.calculator.functions;

import java.util.ArrayList;
import java.util.List;
import org.pipservices3.expressions.calculator.functions.IFunction;
import org.pipservices3.expressions.calculator.functions.IFunctionCollection;

public class FunctionCollection
implements IFunctionCollection {
    private List<IFunction> _functions = new ArrayList<IFunction>();

    @Override
    public void add(IFunction func) {
        if (func == null) {
            throw new NullPointerException("Func cannot be null");
        }
        this._functions.add(func);
    }

    @Override
    public int length() {
        return this._functions.size();
    }

    @Override
    public IFunction get(int index) {
        return this._functions.get(index);
    }

    @Override
    public List<IFunction> getAll() {
        return new ArrayList<IFunction>(this._functions);
    }

    @Override
    public int findIndexByName(String name) {
        name = name.toUpperCase();
        for (int i = 0; i < this._functions.size(); ++i) {
            String varName = this._functions.get(i).getName().toUpperCase();
            if (!varName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IFunction findByName(String name) {
        int index = this.findIndexByName(name);
        return index >= 0 ? this._functions.get(index) : null;
    }

    @Override
    public void remove(int index) {
        this._functions.remove(index);
    }

    @Override
    public void removeByName(String name) {
        int index = this.findIndexByName(name);
        if (index >= 0) {
            this.remove(index);
        }
    }

    @Override
    public void clear() {
        this._functions = new ArrayList<IFunction>();
    }
}

