/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices3.expressions.calculator;

import java.util.ArrayList;
import java.util.List;
import org.pipservices3.expressions.calculator.CalculationStack;
import org.pipservices3.expressions.calculator.ExpressionException;
import org.pipservices3.expressions.calculator.SyntaxException;
import org.pipservices3.expressions.calculator.functions.DefaultFunctionCollection;
import org.pipservices3.expressions.calculator.functions.IFunction;
import org.pipservices3.expressions.calculator.functions.IFunctionCollection;
import org.pipservices3.expressions.calculator.parsers.ExpressionParser;
import org.pipservices3.expressions.calculator.parsers.ExpressionToken;
import org.pipservices3.expressions.calculator.parsers.ExpressionTokenType;
import org.pipservices3.expressions.calculator.variables.IVariable;
import org.pipservices3.expressions.calculator.variables.IVariableCollection;
import org.pipservices3.expressions.calculator.variables.Variable;
import org.pipservices3.expressions.calculator.variables.VariableCollection;
import org.pipservices3.expressions.tokenizers.Token;
import org.pipservices3.expressions.variants.IVariantOperations;
import org.pipservices3.expressions.variants.TypeUnsafeVariantOperations;
import org.pipservices3.expressions.variants.Variant;

public class ExpressionCalculator {
    private final IVariableCollection _defaultVariables = new VariableCollection();
    private final IFunctionCollection _defaultFunctions = new DefaultFunctionCollection();
    private IVariantOperations _variantOperations = new TypeUnsafeVariantOperations();
    private final ExpressionParser _parser = new ExpressionParser();
    private boolean _autoVariables = true;

    public ExpressionCalculator() throws Exception {
    }

    public ExpressionCalculator(String expression) throws Exception {
        if (expression != null) {
            this.setExpression(expression);
        }
    }

    public String getExpression() {
        return this._parser.getExpression();
    }

    public void setExpression(String value) throws Exception {
        this._parser.setExpression(value);
        if (this._autoVariables) {
            this.createVariables(this._defaultVariables);
        }
    }

    public List<Token> getOriginalTokens() {
        return this._parser.getOriginalTokens();
    }

    public void setOriginalTokens(List<Token> value) throws SyntaxException {
        this._parser.setOriginalTokens(value);
        if (this._autoVariables) {
            this.createVariables(this._defaultVariables);
        }
    }

    public boolean getAutoVariables() {
        return this._autoVariables;
    }

    public void setAutoVariables(boolean value) {
        this._autoVariables = value;
    }

    public IVariantOperations getVariantOperations() {
        return this._variantOperations;
    }

    public void setVariantOperations(IVariantOperations value) {
        this._variantOperations = value;
    }

    public IVariableCollection getDefaultVariables() {
        return this._defaultVariables;
    }

    public IFunctionCollection getDefaultFunctions() {
        return this._defaultFunctions;
    }

    public List<ExpressionToken> getInitialTokens() {
        return this._parser.getInitialTokens();
    }

    public List<ExpressionToken> getResultTokens() {
        return this._parser.getResultTokens();
    }

    public void createVariables(IVariableCollection variables) {
        for (String variableName : this._parser.getVariableNames()) {
            if (variables.findByName(variableName) != null) continue;
            variables.add(new Variable(variableName));
        }
    }

    public void clear() {
        this._parser.clear();
        this._defaultVariables.clear();
    }

    public Variant evaluate() throws Exception {
        return this.evaluateWithVariablesAndFunctions(null, null);
    }

    public Variant evaluateWithVariables(IVariableCollection variables) throws Exception {
        return this.evaluateWithVariablesAndFunctions(variables, null);
    }

    public Variant evaluateWithVariablesAndFunctions(IVariableCollection variables, IFunctionCollection functions) throws Exception {
        CalculationStack stack = new CalculationStack();
        variables = variables != null ? variables : this._defaultVariables;
        functions = functions != null ? functions : this._defaultFunctions;
        for (ExpressionToken token : this.getResultTokens()) {
            if (this.evaluateConstant(token, stack) || this.evaluateVariable(token, stack, variables) || this.evaluateFunction(token, stack, functions) || this.evaluateLogical(token, stack) || this.evaluateArithmetical(token, stack) || this.evaluateBoolean(token, stack) || this.evaluateOther(token, stack)) continue;
            throw new ExpressionException(null, "INTERNAL", "Internal error", token.getLine(), token.getColumn());
        }
        if (stack.length() != 1) {
            throw new ExpressionException(null, "INTERNAL", "Internal error", 0, 0);
        }
        return stack.pop();
    }

    private boolean evaluateConstant(ExpressionToken token, CalculationStack stack) {
        if (token.getType() != ExpressionTokenType.Constant) {
            return false;
        }
        stack.push(token.getValue());
        return true;
    }

    private boolean evaluateVariable(ExpressionToken token, CalculationStack stack, IVariableCollection variables) throws ExpressionException {
        if (token.getType() != ExpressionTokenType.Variable) {
            return false;
        }
        IVariable variable = variables.findByName(token.getValue().getAsString());
        if (variable == null) {
            throw new ExpressionException(null, "VAR_NOT_FOUND", "Variable " + token.getValue().getAsString() + " was not found", token.getLine(), token.getColumn());
        }
        stack.push(variable.getValue());
        return true;
    }

    private boolean evaluateFunction(ExpressionToken token, CalculationStack stack, IFunctionCollection functions) throws ExpressionException {
        if (token.getType() != ExpressionTokenType.Function) {
            return false;
        }
        IFunction func = functions.findByName(token.getValue().getAsString());
        if (func == null) {
            throw new ExpressionException(null, "FUNC_NOT_FOUND", "Function " + token.getValue().getAsString() + " was not found", token.getLine(), token.getColumn());
        }
        ArrayList<Variant> params = new ArrayList<Variant>();
        Integer paramCount = stack.pop().getAsInteger();
        while (paramCount > 0) {
            params.add(0, stack.pop());
            Integer n = paramCount;
            paramCount = paramCount - 1;
        }
        Variant functionResult = func.calculate(params, this._variantOperations);
        stack.push(functionResult);
        return true;
    }

    private boolean evaluateLogical(ExpressionToken token, CalculationStack stack) {
        switch (token.getType()) {
            case And: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.and(value1, value2));
                return true;
            }
            case Or: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.or(value1, value2));
                return true;
            }
            case Xor: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.xor(value1, value2));
                return true;
            }
            case Not: {
                stack.push(this._variantOperations.not(stack.pop()));
                return true;
            }
        }
        return false;
    }

    private boolean evaluateArithmetical(ExpressionToken token, CalculationStack stack) {
        switch (token.getType()) {
            case Plus: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.add(value1, value2));
                return true;
            }
            case Minus: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.sub(value1, value2));
                return true;
            }
            case Star: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.mul(value1, value2));
                return true;
            }
            case Slash: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.div(value1, value2));
                return true;
            }
            case Procent: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.mod(value1, value2));
                return true;
            }
            case Power: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.pow(value1, value2));
                return true;
            }
            case Unary: {
                stack.push(this._variantOperations.negative(stack.pop()));
                return true;
            }
            case ShiftLeft: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.lsh(value1, value2));
                return true;
            }
            case ShiftRight: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.rsh(value1, value2));
                return true;
            }
        }
        return false;
    }

    private boolean evaluateBoolean(ExpressionToken token, CalculationStack stack) {
        switch (token.getType()) {
            case Equal: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.equal(value1, value2));
                return true;
            }
            case NotEqual: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.notEqual(value1, value2));
                return true;
            }
            case More: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.more(value1, value2));
                return true;
            }
            case Less: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.less(value1, value2));
                return true;
            }
            case EqualMore: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.moreEqual(value1, value2));
                return true;
            }
            case EqualLess: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                stack.push(this._variantOperations.lessEqual(value1, value2));
                return true;
            }
        }
        return false;
    }

    private boolean evaluateOther(ExpressionToken token, CalculationStack stack) throws Exception {
        switch (token.getType()) {
            case In: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                Variant rvalue = this._variantOperations.in(value2, value1);
                stack.push(rvalue);
                return true;
            }
            case NotIn: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                Variant rvalue = this._variantOperations.in(value2, value1);
                rvalue = Variant.fromBoolean(rvalue.getAsBoolean() == false);
                stack.push(rvalue);
                return true;
            }
            case Element: {
                Variant value2 = stack.pop();
                Variant value1 = stack.pop();
                Variant rvalue = this._variantOperations.getElement(value1, value2);
                stack.push(rvalue);
                return true;
            }
            case IsNull: {
                Variant rvalue = new Variant(stack.pop().isNull());
                stack.push(rvalue);
                return true;
            }
            case IsNotNull: {
                Variant rvalue = new Variant(!stack.pop().isNull());
                stack.push(rvalue);
                return true;
            }
        }
        return false;
    }
}

