/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices.messaging.queues;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.time.ZonedDateTime;
import org.pipservices.commons.convert.JsonConverter;
import org.pipservices.commons.convert.StringConverter;
import org.pipservices.commons.data.IdGenerator;

public class MessageEnvelop {
    private String _messageId;
    private String _messageType;
    private String _correlationId;
    private Object _message;
    private Object _reference;
    private ZonedDateTime _sentTime;

    public MessageEnvelop() {
    }

    public MessageEnvelop(String correlationId, String messageType, Object message) {
        this._correlationId = correlationId;
        this._messageType = messageType;
        this._message = message;
        this._messageId = IdGenerator.nextLong();
    }

    public MessageEnvelop(String correlationId, String messageType, String message) {
        this._correlationId = correlationId;
        this._messageType = messageType;
        this.setMessage(message);
        this._messageId = IdGenerator.nextLong();
    }

    @JsonIgnore
    public Object getReference() {
        return this._reference;
    }

    public void setReference(Object value) {
        this._reference = value;
    }

    @JsonProperty(value="correlation_id")
    public String getCorrelationId() {
        return this._correlationId;
    }

    public void setCorrelationId(String value) {
        this._correlationId = value;
    }

    @JsonProperty(value="message_id")
    public String getMessageId() {
        return this._messageId;
    }

    public void setMessageId(String value) {
        this._messageId = value;
    }

    @JsonProperty(value="message_type")
    public String getMessageType() {
        return this._messageType;
    }

    public void setMessageType(String value) {
        this._messageType = value;
    }

    @JsonProperty(value="sent_time")
    public ZonedDateTime getSentTime() {
        return this._sentTime;
    }

    public void setSentTime(ZonedDateTime value) {
        this._sentTime = value;
    }

    @JsonProperty(value="message")
    public Object getMessage() {
        return this._message;
    }

    public void setMessage(Object value) {
        this._message = value;
    }

    public void setMessageAsJson(Object message) throws JsonProcessingException {
        this._message = JsonConverter.toJson((Object)message);
    }

    public <T> T getMessageAsJson(Class<T> type) throws JsonMappingException, JsonParseException, IOException {
        return (T)JsonConverter.fromJson(type, (String)this._message.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(this._correlationId != null ? this._correlationId : "---").append(",").append(this._messageType != null ? this._messageType : "---").append(",").append(this._message != null ? StringConverter.toString((Object)this._message) : "--").append("]");
        return builder.toString();
    }
}

