package com.client.basic.version1;

import jakarta.ws.rs.HttpMethod;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.http.clients.RestClient;
import com.service.basic.data.version1.*;

public class BasicRestClientV1 extends RestClient implements IBasicClientV1{
    
    public BasicRestClientV1(Object config) {
        super();
        this._baseRoute = "basic/v1";

        if (config != null)
            this.configure(ConfigParams.fromValue(config));
    }

    public BasicRestClientV1() {
        super();
        this._baseRoute = "basic/v1";
    }
    
    @Override
    public ResponseV1 doSomething(IContext context, RequestV1 request) throws ApplicationException {
        if (request != null) {
            var timing = this.instrument(context, this._baseRoute + ".do_something");
            try {
                ResponseV1 res = this.call(
                        ResponseV1.class,
                        context,
                        HttpMethod.POST,
                        "/do_something",
                        request
                );
                timing.endTiming();
                return res;
            } catch (Exception ex) {
                timing.endFailure(ex);
                throw ex;
            }
        } else {
            throw new NullPointerException("NullPointerException");
        }
    }
}
