package com.client.basic.version1;

import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.http.clients.CommandableHttpClient;
import com.service.basic.data.version1.*;


public class BasicCommandableHttpClientV1 extends CommandableHttpClient implements IBasicClientV1 {

    public BasicCommandableHttpClientV1(Object config) {
        super("commandable_basic/v1");

        if (config != null)
            this.configure(ConfigParams.fromValue(config));
    }

    public BasicCommandableHttpClientV1() {
        super("commandable_basic/v1");
    }

    public ResponseV1 doSomething(IContext context, RequestV1 request) throws ApplicationException {
        if (request != null) {
            return callCommand(
                    ResponseV1.class,
                    "do_something",
                    context,
                    Parameters.fromTuples("request", request));
        } else {
            throw new NullPointerException("NullPointerException");
        }
    }
}
