package com.client.basic.build;

import com.client.basic.version1.*;
import org.pipservices4.components.build.Factory;
import org.pipservices4.components.refer.Descriptor;

public class BasicClientFactory extends Factory {
    public static final Descriptor NullClientDescriptor = new Descriptor("service-basic", "client", "null", "*", "1.0");
    public static final Descriptor DirectClientDescriptor = new Descriptor("service-basic", "client", "direct", "*", "1.0");
    public static final Descriptor BasicMockClientV1Descriptor = new Descriptor("service-basic", "client", "mock", "*", "1.0");

    public static final Descriptor HttpClientDescriptor = new Descriptor("service-basic", "client", "http", "*", "1.0");
    public static final Descriptor GrpcClientDescriptor = new Descriptor("service-basic", "client", "grpc", "*", "1.0");    

    public static final Descriptor CommandableHttpClientDescriptor = new Descriptor("service-basic", "client", "commandable-http", "*", "1.0");
    public static final Descriptor CommandableGrpcClientDescriptor = new Descriptor("service-basic", "client", "commandable-grpc", "*", "1.0");    

    public BasicClientFactory() {
        super();
        this.registerAsType(BasicClientFactory.NullClientDescriptor, BasicNullClientV1.class);
        this.registerAsType(BasicClientFactory.BasicMockClientV1Descriptor, BasicMockClientV1.class);
        this.registerAsType(BasicClientFactory.DirectClientDescriptor, BasicDirectClientV1.class);

        this.registerAsType(BasicClientFactory.HttpClientDescriptor, BasicRestClientV1.class);
        this.registerAsType(BasicClientFactory.GrpcClientDescriptor, BasicGrpcClientV1.class);

        this.registerAsType(BasicClientFactory.CommandableHttpClientDescriptor, BasicCommandableHttpClientV1.class);
        this.registerAsType(BasicClientFactory.CommandableGrpcClientDescriptor, BasicCommandableGrpcClientV1.class);
    }
}
