package com.client.basic.version1;

import com.service.basic.controllers.version1.BasicRestControllerV1;
import com.service.basic.logic.BasicService;
import org.junit.*;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

public class BasicRestClientV1Test {
    static BasicRestControllerV1 controller;
    static BasicRestClientV1 client;
    static BasicClientV1Fixture fixture;

    static ConfigParams restConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3001
    );

    @BeforeClass
    public static void setupClass() throws ApplicationException {
        var service = new BasicService();

        controller = new BasicRestControllerV1();
        controller.configure(restConfig);

        client = new BasicRestClientV1();
        client.configure(restConfig);

        References references = References.fromTuples(
            new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
            new Descriptor("service-basic", "controller", "rest-http", "default", "1.0"), controller,
            new Descriptor("service-basic", "client", "rest-http", "default", "1.0"), client
        );

        service.setReferences(references);
        controller.setReferences(references);
        client.setReferences(references);

        controller.open(null);
        client.open(null);

        fixture = new BasicClientV1Fixture(client);
    }    

    @AfterClass
    public static void teardown() throws ApplicationException {
        client.close(null);
        controller.close(null);
    }

    @Test
    public void testOperations() throws ApplicationException {
        fixture.testOperations();
    }
}
