package com.client.basic.version1;

import com.service.basic.logic.BasicService;
import org.junit.Before;
import org.junit.Test;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

public class BasicDirectClientV1Test {
    static BasicService service;
    static BasicDirectClientV1 client;
    static BasicClientV1Fixture fixture;
	
    @Before
    public void setUp() throws ApplicationException {
        service = new BasicService();
        client = new BasicDirectClientV1();

        References references = References.fromTuples(
            new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
            new Descriptor("service-basic", "client", "direct", "default", "1.0"), client
        );
        service.setReferences(references);
        client.setReferences(references);

        fixture = new BasicClientV1Fixture(client);
    }
    
    @Test
    public void testOperations() throws ApplicationException {
    	fixture.testOperations();
	}
}
