package com.client.basic.version1;

import com.service.basic.controllers.version1.BasicCommandableGrpcControllerV1;
import com.service.basic.logic.BasicService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.References;

public class BasicCommandableGrpcClientV1Test {
    static BasicCommandableGrpcControllerV1 controller;
    static BasicCommandableGrpcClientV1 client;
    static BasicClientV1Fixture fixture;

    static ConfigParams httpConfig = ConfigParams.fromTuples(
            "connection.protocol", "http",
            "connection.host", "localhost",
            "connection.port", 3001
    );

    @Before
    public void setup() throws ApplicationException {
        var service = new BasicService();

        controller = new BasicCommandableGrpcControllerV1();
        controller.configure(httpConfig);

        client = new BasicCommandableGrpcClientV1();
        client.configure(httpConfig);

        References references = References.fromTuples(
            new Descriptor("service-basic", "service", "default", "default", "1.0"), service,
            new Descriptor("service-basic", "controller", "grpc", "default", "1.0"), controller,
            new Descriptor("service-basic", "client", "grpc", "default", "1.0"), client
        );

        service.setReferences(references);
        controller.setReferences(references);
        client.setReferences(references);

        controller.open(null);
        client.open(null);

        fixture = new BasicClientV1Fixture(client);
    }    

    @After
    public void teardown() throws ApplicationException {
        client.close(null);
        controller.close(null);
    }

    @Test
    public void testOperations() throws ApplicationException {
        fixture.testOperations();
    }
}
