package com.client.basic.version1;

import org.pipservices4.commons.errors.ApplicationException;
import com.service.basic.data.version1.*;

import static org.junit.Assert.*;

public class BasicClientV1Fixture {
    private final IBasicClientV1 _client;

    public BasicClientV1Fixture(IBasicClientV1 client) {
        assertNotNull(client);
        _client = client;
    }

    public void testOperations() throws ApplicationException {
        // Happy path
        RequestV1 req = new RequestV1("test_value");
        ResponseV1 res = _client.doSomething(null, req);
        assertNotNull(res);
        assertEquals(req.getValue(), res.getValue());

        // Boundary
        req.setValue("");
        res = _client.doSomething(null, req);
        assertEquals("", res.getValue());

        // Negative
        assertThrows(NullPointerException.class, () -> _client.doSomething(null, null));
    }
}
