package com.client.basic.version1;

import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.grpc.clients.GrpcClient;
import com.service.basic.data.version1.*;

public class BasicGrpcClientV1 extends GrpcClient implements IBasicClientV1 {
    public BasicGrpcClientV1() {
        super(com.client.basic.protos.BasicControllerGrpc.getServiceDescriptor());
    }

    @Override
    public ResponseV1 doSomething(IContext context, RequestV1 request) {
        if (request != null) {
            var query = com.client.basic.protos.Query.newBuilder()
                    .setRequest(com.client.basic.protos.RequestV1.newBuilder().setValue(request.getValue()).build())
                    .setTraceId(ContextResolver.getTraceId(context) != null ? ContextResolver.getTraceId(context) : "")
                    .build();

            var timing = this.instrument(context, "v1.basic_grpc.do_something");
            try {
                var response = this.call("do_something", context, query);

                timing.endTiming();
                com.client.basic.protos.ResponseV1 res = (com.client.basic.protos.ResponseV1) response;

                return res != null ? new ResponseV1(res.getValue()) : null;
            } catch (Exception ex) {
                timing.endFailure(ex);
                throw ex;
            }
        } else {
            throw new NullPointerException("NullPointerException");
        }
    }
}
