package com.client.basic.version1;

import com.service.basic.logic.IBasicService;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.rpc.clients.DirectClient;
import com.service.basic.data.version1.*;

public class BasicDirectClientV1 extends DirectClient<IBasicService> implements IBasicClientV1 {

    public BasicDirectClientV1() {
        super();
        _dependencyResolver.put("service", new Descriptor("service-basic", "service", "*", "*", "1.0"));
    }

    @Override
    public ResponseV1 doSomething(IContext context, RequestV1 request) {
        var timing = this.instrument(context, "v1.basic.do_something");
        try {
            var res = _service.doSomething(context, new com.service.basic.data.version1.RequestV1(request.getValue()));
            timing.endTiming();
            return new ResponseV1(res.getValue());
        } catch (Exception ex) {
            timing.endFailure(ex);
            throw ex;
        }
    }

}
