# Basic Client Library in Java

This basic client library executes simple requests.

Supported functionality:
* gRPC, HTTP clients (and Commandable versions)
* Direct client to connect to the microservice in-process
* Mock client to be used as a mock in automated tests

<a name="links"></a> Quick links:

* Communication Protocols:
* [Microservice](../service-basic-pipservices)
* [API Reference](docs)
* [Change Log](CHANGELOG.md)

##  Contract

```java
public class RequestV1 {
    @JsonProperty("value")
    private String value;

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

public class ResponseV1 {
    @JsonProperty("value")
    private String value;

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

public interface IBasicClientV1 {
    ResponseV1 doSomething(IContext context, RequestV1 request);
}
```


## Get

Get the client library source from Bitbucket:
```bash
git clone git@bitbucket.org:entinco/eic-templates-services-java.git
```

## Use


Go to the pom.xml file in Maven project and add dependencies:
```xml
<dependency>
    <groupId>org.pipservices</groupId>
    <artifactId>client-basic-pipservices</artifactId>
    <version>1.0.0</version>
</dependency>
```

Inside your code get the reference to the client library
```java
import com.client.basic.BasicCommandableHttpClientV1;
```

Instantiate the client
```java
// Create the client instance
var client = new BasicCommandableHttpClientV1();
```

Define client configuration parameters.
```java
// Client configuration
var httpConfig = ConfigParams.fromTuples(
    "connection.protocol", "http",
    "connection.host", "localhost",
    "connection.port", 3000
);
client.configure(httpConfig);
```

Connect to the microservice
```java
// Connect to the microservice
client.open(Context.fromTraceId("123"));
```

Create a new entity
```java
var req = new RequestV1('Bla bla bla');

res = client.doSomething(Context.fromTraceId("123"), req);
console.log("Response: " + res.value);
```


## Develop

For development you shall install the following prerequisites:
* Java 16+
* Maven 3+
* Visual Studio Code or another IDE of your choice
* Docker

Compile the library:
```bash
mvn compile
```

Run automated tests:
```bash
mvn test
```

Run performance benchmark:
```bash
mvn exec:exec@benchmark
```
Run linter:
```bash
mvn checkstyle:check
```

Generate API documentation:
```bash
./docgen.ps1
```

Before committing changes run dockerized build and test as:
```bash
./build.ps1
./test.ps1
./clean.ps1
```

## Contacts

This client library was created by and is currently maintained by *Responsible Person Name*.