/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicComponentParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;
    private static final Map<Class, Converter> stringConverters = new HashMap<Class, Converter>();

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        Class resolvedClassType = null;
        if (!(expectedType instanceof Class)) {
            if (!(expectedType instanceof ParameterizedType)) return false;
            resolvedClassType = (Class)((ParameterizedType)expectedType).getRawType();
        } else {
            resolvedClassType = (Class)expectedType;
        }
        assert (resolvedClassType != null);
        if (this.resolveAdapter(container, adapter, resolvedClassType, expectedNameBinding, useNames, binding) == null) return false;
        return true;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, (Class)expectedType, expectedNameBinding, useNames, binding);
        if (componentAdapter != null) {
            Object o = container.getComponent(componentAdapter.getComponentKey(), adapter.getComponentImplementation());
            if (o instanceof String && expectedType != String.class) {
                Converter converter = stringConverters.get(expectedType);
                return converter.convert((String)o);
            }
            return o;
        }
        return null;
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, (Class)expectedType, expectedNameBinding, useNames, binding);
        if (componentAdapter == null) {
            HashSet<Type> set = new HashSet<Type>();
            set.add(expectedType);
            throw new AbstractInjector.UnsatisfiableDependenciesException(adapter, null, set, container);
        }
        componentAdapter.verify(container);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private <T> ComponentAdapter<T> resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class<T> expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter<T> result;
        Class<Object> type = expectedType;
        if (type.isPrimitive()) {
            String expectedTypeName = expectedType.getName();
            if (expectedTypeName == "int") {
                type = Integer.class;
            } else if (expectedTypeName == "long") {
                type = Long.class;
            } else if (expectedTypeName == "float") {
                type = Float.class;
            } else if (expectedTypeName == "double") {
                type = Double.class;
            } else if (expectedTypeName == "boolean") {
                type = Boolean.class;
            } else if (expectedTypeName == "char") {
                type = Character.class;
            } else if (expectedTypeName == "short") {
                type = Short.class;
            } else if (expectedTypeName == "byte") {
                type = Byte.class;
            }
        }
        if ((result = this.getTargetAdapter(container, type, expectedNameBinding, adapter, useNames, binding)) == null) {
            return null;
        }
        if (!(type.isAssignableFrom(result.getComponentImplementation()) || result.getComponentImplementation() == String.class && stringConverters.containsKey(type))) {
            return null;
        }
        return result;
    }

    private static <T> ComponentAdapter<T> typeComponentAdapter(ComponentAdapter<?> componentAdapter) {
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> getTargetAdapter(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, ComponentAdapter excludeAdapter, boolean useNames, Annotation binding) {
        if (this.componentKey != null) {
            return BasicComponentParameter.typeComponentAdapter(container.getComponentAdapter(this.componentKey));
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapter(expectedType, (NameBinding)null);
        }
        return this.findTargetAdapter(container, expectedType, expectedNameBinding, excludeAdapter, useNames, binding);
    }

    private <T> ComponentAdapter<T> findTargetAdapter(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, ComponentAdapter excludeAdapter, boolean useNames, Annotation binding) {
        Object found;
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter<?> byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return BasicComponentParameter.typeComponentAdapter(byKey);
        }
        if (useNames && (found = container.getComponentAdapter(expectedNameBinding.getName())) != null && this.areCompatible(expectedType, (ComponentAdapter)found) && found != excludeAdapter) {
            return found;
        }
        found = binding == null ? container.getComponentAdapters(expectedType) : container.getComponentAdapters(expectedType, binding.annotationType());
        this.removeExcludedAdapterIfApplicable(excludeKey, (List<ComponentAdapter<T>>)found);
        if (found.size() == 0) {
            return this.noMatchingAdaptersFound(container, expectedType, expectedNameBinding, binding);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        throw this.tooManyMatchingAdaptersFound(expectedType, (List<ComponentAdapter<T>>)found);
    }

    private <T> ComponentAdapter<T> noMatchingAdaptersFound(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, Annotation binding) {
        if (container.getParent() != null) {
            if (binding != null) {
                return container.getParent().getComponentAdapter(expectedType, binding.getClass());
            }
            return container.getParent().getComponentAdapter(expectedType, expectedNameBinding);
        }
        return null;
    }

    private <T> AbstractInjector.AmbiguousComponentResolutionException tooManyMatchingAdaptersFound(Class<T> expectedType, List<ComponentAdapter<T>> found) {
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        AbstractInjector.AmbiguousComponentResolutionException exception = new AbstractInjector.AmbiguousComponentResolutionException(expectedType, foundClasses);
        return exception;
    }

    private <T> void removeExcludedAdapterIfApplicable(Object excludeKey, List<ComponentAdapter<T>> found) {
        ComponentAdapter<T> exclude = null;
        for (ComponentAdapter<T> work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
            break;
        }
        found.remove(exclude);
    }

    private <T> boolean areCompatible(Class<T> expectedType, ComponentAdapter found) {
        Class foundImpl = found.getComponentImplementation();
        return expectedType.isAssignableFrom(foundImpl) || foundImpl == String.class && stringConverters.containsKey(expectedType);
    }

    static {
        stringConverters.put(Integer.class, new ValueOfConverter(Integer.class));
        stringConverters.put(Double.class, new ValueOfConverter(Double.class));
        stringConverters.put(Boolean.class, new ValueOfConverter(Boolean.class));
        stringConverters.put(Long.class, new ValueOfConverter(Long.class));
        stringConverters.put(Float.class, new ValueOfConverter(Float.class));
        stringConverters.put(Character.class, new ValueOfConverter(Character.class));
        stringConverters.put(Byte.class, new ValueOfConverter(Byte.class));
        stringConverters.put(Byte.class, new ValueOfConverter(Short.class));
        stringConverters.put(File.class, new NewInstanceConverter(File.class));
    }

    private static class NewInstanceConverter
    implements Converter {
        private Constructor c;

        private NewInstanceConverter(Class clazz) {
            try {
                this.c = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public Object convert(String paramValue) {
            try {
                return this.c.newInstance(paramValue);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class ValueOfConverter
    implements Converter {
        private Method m;

        private ValueOfConverter(Class clazz) {
            try {
                this.m = clazz.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public Object convert(String paramValue) {
            try {
                return this.m.invoke(null, paramValue);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

